% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subtree.R
\name{subtree}
\alias{subtree}
\title{SEMtree Partitioning Tool}
\usage{
subtree(tree, startNode = NULL, level = 0, foundNode = FALSE)
}
\arguments{
\item{tree}{A SEMtree object obtained from \code{\link{semtree}}}

\item{startNode}{Node id, which will be future root node (0 to max node
number of \code{tree)}}

\item{level}{Ignore. Only used internally.}

\item{foundNode}{Ignore. Only used internally.}
}
\value{
Returns a \code{\link{semtree}} object which is a partitioned tree
from the input \code{semtree}.
}
\description{
The \code{subtree} function returns a tree from a selected node of the
\code{\link{semtree}} returned tree.
}
\details{
The row names of the resulting data frame correspond to internal node ids
and the column names correspond to standard errors in the SEM. Standard
errors of the estimates can be obtained from \code{\link{se}}.
}
\references{
Brandmaier, A.M., Oertzen, T. v., McArdle, J.J., & Lindenberger,
U. (2013). Structural equation model trees. \emph{Psychological Methods},
18(1), 71-86.
}
\seealso{
\code{\link{semtree}}, \code{\link{semtree.control}}
}
\author{
Andreas M. Brandmaier, John J. Prindle
}
