% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_node_label.R
\name{change_node_label}
\alias{change_node_label}
\title{Change node labels}
\usage{
change_node_label(
  semPaths_plot,
  label_list = NULL,
  label.cex,
  label.scale,
  label.prop,
  label.norm
)
}
\arguments{
\item{semPaths_plot}{A \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths}, or a similar qgraph object modified by other
\link{semptools} functions.}

\item{label_list}{A list of named lists. Each named list should
have two named values: \code{node} and \code{to}. The first part,
\code{node}, is a character denoting the label to be changed. It
should be as appeared in the qgraph. The second part, \code{to}, is
the new label. Expression can be used in \code{to}. A named vector
can also be used, with the names being the nodes to be changed, and
the values the new labels.}

\item{label.cex}{Identical to the same argument in
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. A number tha control the size of labels in
the nodes. It has no default. If not set, then this option in the
\code{semPaths_plot} will not be changed.}

\item{label.scale}{Identical to the same argument in
\link[semPlot:semPaths]{semPlot::semPaths}. A logical value that determine whether labels
wil be scaled (resized) to the nodes they attach to. It has no
default. If not set, then this option in the \code{semPaths_plot} will
not be changed.}

\item{label.prop}{Identical to the same argument in
\link[semPlot:semPaths]{semPlot::semPaths}. A numeric vector of length equal to the number
of nodes. If \code{label.scale} is \code{TRUE}, this number is the proportion
of the width of a node that its label will be scaled (resized) to.
It has no default. If not set, then this option in the
\code{semPaths_plot} will not be changed.}

\item{label.norm}{Identical to the same argument in
\link[semPlot:semPaths]{semPlot::semPaths}. It must be a string. All labels as wide as or
narrower than this string will have the same font size, while all
labels wider than this string will be rescaled to have the same
width as this string. It has no default. If not set, then this
option in the \code{semPaths_plot} will not be changed.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} based on the original one, with node
attributes of selected nodes modified.
}
\description{
Change the labels of selected nodes.
}
\details{
Modify a \link[qgraph:qgraph]{qgraph::qgraph} object generated by
\link[semPlot:semPaths]{semPlot::semPaths} and change the labels of selected nodes.

\code{change_node_label2()} is an experimental version that takes a
named list as input.
}
\examples{
library(semPlot)
library(lavaan)
mod_pa <-
 'x1 ~~ x2
  x3 ~  x1 + x2
  x4 ~  x1 + x3
 '
fit_pa <- sem(mod_pa, pa_example)
parameterEstimates(fit_pa)[, c("lhs", "op", "rhs", "est", "pvalue")]
m <- matrix(c("x1",   NA,   NA,
               NA, "x3", "x4",
             "x2",   NA,   NA), byrow = TRUE, 3, 3)
p_pa <- semPaths(fit_pa, whatLabels="est",
           style = "ram",
           nCharNodes = 0, nCharEdges = 0,
           layout = m)

my_label_list <- list(list(node = "x3", to = "mediator"),
                     list(node = "x4", to = expression(gamma)))

p_pa2 <- change_node_label(p_pa, my_label_list)
plot(p_pa2)

}
