% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_bound_wn_i.R
\name{ci_bound_wn_i}
\alias{ci_bound_wn_i}
\title{Likelihood-based Confidence Bound For One parameter}
\usage{
ci_bound_wn_i(
  i = NULL,
  npar = NULL,
  sem_out = NULL,
  f_constr = NULL,
  which = NULL,
  history = FALSE,
  perturbation_factor = 0.9,
  lb_var = -Inf,
  standardized = FALSE,
  wald_ci_start = !standardized,
  opts = list(),
  ciperc = 0.95,
  ci_limit_ratio_tol = 1.5,
  verbose = FALSE,
  sf = 1,
  sf2 = 0,
  p_tol = 5e-04,
  std_method = "internal",
  bounds = "none",
  xtol_rel_factor = 1,
  ftol_rel_factor = 1,
  lb_prop = 0.05,
  lb_se_k = 3,
  ...
)
}
\arguments{
\item{i}{The position of the target parameter as appeared in the
parameter table of an lavaan object, generated by
\code{\link[lavaan:lavParTable]{lavaan::parameterTable()}}.}

\item{npar}{The number of free parameters, including those
constrained to be equal.}

\item{sem_out}{The fit object. Currently supports
\link[lavaan:lavaan-class]{lavaan::lavaan} objects only.}

\item{f_constr}{The constraint function generated by
\code{\link[=set_constraint]{set_constraint()}}.}

\item{which}{Whether the lower bound or the upper bound is to be
found. Must be \code{"lbound"} or \code{"ubound"}.}

\item{history}{Not used. Kept for backward compatibility.}

\item{perturbation_factor}{A number multiplied to the parameter
estimates in \code{sem_out}. Using the parameter estimates as starting
values may lead to errors in the first few iterations. Default is
.90. This argument is ignored if \code{wald_ci_start} is `TRUE.}

\item{lb_var}{The lower bound for free parameters that are
variances. If equal to \code{-Inf}, the default, \code{lb_prop} and
\code{lb_se_k} will be used to set the lower bounds for free variances.
If it is a number, it will be used to set the lower bounds for all
free variances.}

\item{standardized}{If \code{TRUE}, the LBCI is for the requested
estimate in the standardized solution. Default is \code{FALSE}.}

\item{wald_ci_start}{If \code{TRUE}, there are no equality
constraints in the model, and the target parameter is not a
user-defined parameter, the Wald confidence bounds will be used as
the starting value.}

\item{opts}{Options to be passed to \code{\link[nloptr:nloptr]{nloptr::nloptr()}}, the current
optimizer. Default is \code{list()}.}

\item{ciperc}{The intended coverage probability for the confidence
interval. Default is .95, and the bound for a 95\% confidence
interval will be sought.}

\item{ci_limit_ratio_tol}{The tolerance for the ratio of \code{a} to
\code{b}, where \code{a} is the distance between an LBCI limit and the point
estimate, and the \code{b} is the distance between the original
confidence limit (by default the Wald CI in \code{\link[lavaan:lavaan]{lavaan::lavaan()}})
and the point estimate. If the ratio is larger than this value or
smaller than the reciprocal of this value, a warning is set in the
status code. Default is 1.5.}

\item{verbose}{If \code{TRUE}, the function will store more diagnostic
information in the attribute \code{diag}. Default is \code{FALSE}.}

\item{sf}{A scaling factor. Used for robust confidence bounds.
Default is 1. Computed by an internal function called by
\code{\link[=semlbci]{semlbci()}} when \code{robust = "satorra.2000"}.}

\item{sf2}{A shift factor. Used for robust confidence bounds.
Default is 0. Computed by an internal function called by
\code{\link[=semlbci]{semlbci()}} when \code{robust = "satorra.2000"}.}

\item{p_tol}{Tolerance for checking the achieved level of
confidence. If the absolute difference between the achieved level
and \code{ciperc} is greater than this amount, a warning is set in the
status code and the bound is set to \code{NA}. Default is 5e-4.}

\item{std_method}{The method used to find the standardized
solution. If equal to \verb{"lavaan"``, [lavaan::standardizedSolution()] will be used. If equal to }"internal"\verb{, an internal function will be used. The }"lavaan"\verb{method should work in all situations, but the}"internal"\verb{method is usually much faster. Default is}"internal"`.}

\item{bounds}{Default is \code{""} and this function will set the lower
bounds to \code{lb_var} for variances. Other valid values are those
accepted by \code{\link[lavaan:lavaan]{lavaan::lavaan()}}. Ignored for now.}

\item{xtol_rel_factor}{Multiply the default \code{xtol_rel} by a number,
usually a positive number equal to or less than 1, to change the
default termination criterion. Default is 1.}

\item{ftol_rel_factor}{Multiply the default \code{ftol_rel} by a number,
usually a positive number equal to or less than 1, to change the
default termination criterion. Default is 1.}

\item{lb_prop}{Used by an internal function to set the lower bound
for free variances. Default is .05, setting the lower bound to
.05 * estimate. Used only if the lower bound set by \code{lb_se_k} is
negative.}

\item{lb_se_k}{Used by an internal function to set the lower bound
for free variances. Default is 3, the estimate minus 3 standard
error. If negative, the lower bound is set using \code{lb_prop}.}

\item{...}{Optional arguments. Not used.}
}
\value{
A \code{cibound}-class object which is a list with three elements:
\itemize{
\item \code{bound}: A single number. The value of the bound located. \code{NA} is
the search failed for various reasons.
\item \code{diag}: A list of diagnostic information.
\item \code{call}: The original call.
}

A detailed and organized output can be printed by the default print
method (\code{\link[=print.cibound]{print.cibound()}}).
}
\description{
Find the lower or upper bound of the likelihood-based
confidence interval (LBCI) for one parameter in a structural
equation model fitted in \code{\link[lavaan:lavaan]{lavaan::lavaan()}}.
}
\details{
\subsection{Important Notice}{

This function is not supposed to be used directly by users in
typical scenarios. Its interface is user-\emph{unfriendly} because it
should be used through \code{\link[=semlbci]{semlbci()}}. It is exported such that
interested users can examine how a confidence bound is found, or
use it for experiments or simulations.
}

\subsection{Usage}{

This function is the lowest level function used by \code{\link[=semlbci]{semlbci()}}.
\code{\link[=semlbci]{semlbci()}} calls this function once for each bound of each
parameter. To use it, \code{\link[=set_constraint]{set_constraint()}} needs to be called first
to create the equality constraint required by the algorithm
proposed by Wu and Neale (2012).
}

\subsection{Algorithm}{

This function implements the algorithm presented in Wu and Neale
(2012; see also Pek & Wu, 2015, Equation 12) that estimates all
free parameters in the optimization.
}

\subsection{Limitation(s)}{

This function does not yet implement the method by Wu and Neale
(2012) for an estimate close to an attainable bound.
}
}
\examples{

data(simple_med)
dat <- simple_med

mod <-
"
m ~ x
y ~ m
"

fit_med <- lavaan::sem(mod, simple_med, fixed.x = FALSE)

fn_constr0 <- set_constraint(fit_med)

out1l <- ci_bound_wn_i(i = 1,
                       npar = 5,
                       sem_out = fit_med,
                       f_constr = fn_constr0,
                       which = "lbound")
out1l

}
\references{
Pek, J., & Wu, H. (2015). Profile likelihood-based confidence
intervals and regions for structural equation models.
\emph{Psychometrika, 80}(4), 1123-1145.
\doi{10.1007/s11336-015-9461-1}

Wu, H., & Neale, M. C. (2012). Adjusted confidence intervals for a
bounded parameter. \emph{Behavior Genetics, 42}(6), 886-898.
\doi{10.1007/s10519-012-9560-z}
}
\seealso{
\code{\link[=print.cibound]{print.cibound()}}, \code{\link[=semlbci]{semlbci()}}, \code{\link[=ci_i_one]{ci_i_one()}}
}
