% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/value_box_output.R
\name{render_value_box}
\alias{render_value_box}
\alias{renderValueBox}
\alias{renderInfoBox}
\title{Create a value box output.}
\usage{
render_value_box(expr, env = parent.frame(), quoted = FALSE)

renderValueBox(expr, env = parent.frame(), quoted = FALSE)

renderInfoBox(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{expr}{ValueBox.}

\item{env}{The environment in which to evaluate expr.}

\item{quoted}{Is expr a quoted expression (with \code{quote()})? This is useful if you want to save an expression in a variable.}
}
\value{
A dynamic valueBox that can be assigned to output.
}
\description{
Server-side function for dynamic valueBox.
}
\section{Functions}{
\itemize{
\item \code{renderValueBox}: Create a value box output (alias for \code{render_value_box} for compatibility with \code{shinydashboard})

\item \code{renderInfoBox}: Create a value box output (alias for \code{render_value_box} for compatibility with \code{shinydashboard})
}}

\examples{
\donttest{
valueBoxOutput("value_box")

output$value_box <- renderValueBox({
  valueBox(
    value = 33.45,
    subtitle = "Simple valuebox",
    icon = icon("bar chart"),
    color = "purple",
    width = 5)
})
}
}
