% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{getPhi.B}
\alias{getPhi.B}
\title{getPhi.B}
\usage{
getPhi.B(B, lPsi = NULL)
}
\arguments{
\item{B}{matrix of regression coefficients (all-y notation). Must only contain non-zero lower-triangular elements, so the first row only includes zeros.}

\item{lPsi}{(lesser) matrix of residual correlations. This is not the Psi matrix, but a lesser version ignoring all variances and containing correlations off the diagonal. Can be omitted for no correlations beyond those implied by B.}
}
\value{
Returns the implied correlation matrix
}
\description{
Computes implied correlations (completely standardized) from Beta matrix, disallowing recursive paths.
}
\examples{
\dontrun{
# mediation model
B <- matrix(c(
  c(.00, .00, .00),
  c(.10, .00, .00),
  c(.20, .30, .00)
), byrow = TRUE, ncol = 3)
Phi <- getPhi.B(B)

# CLPM with residual correlations 
B <- matrix(c(
  c(.00, .00, .00, .00),
  c(.30, .00, .00, .00),
  c(.70, .10, .00, .00),
  c(.20, .70, .00, .00)
), byrow = TRUE, ncol = 4)
lPsi <- matrix(c(
  c(.00, .00, .00, .00),
  c(.00, .00, .00, .00),
  c(.00, .00, .00, .30),
  c(.00, .00, .30, .00)
), byrow = TRUE, ncol = 4)
Phi <- getPhi.B(B, lPsi)
}
}
