% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aPriori.R
\name{semPower.aPriori}
\alias{semPower.aPriori}
\title{semPower.aPriori}
\usage{
semPower.aPriori(effect = NULL, effect.measure = NULL, alpha, beta = NULL,
  power = NULL, df, p = NULL, SigmaHat = NULL, Sigma = NULL)
}
\arguments{
\item{effect}{effect size specifying the discrepancy between H0 and H1}

\item{effect.measure}{type of effect, one of "F0", "RMSEA", "Mc", "GFI", AGFI"}

\item{alpha}{alpha error}

\item{beta}{beta error; set either beta or power}

\item{power}{power (1-beta); set either beta or power}

\item{df}{the model degrees of freedom}

\item{p}{the number of observed variables, required for effect.measure = "GFI" and "AGFI"}

\item{SigmaHat}{model implied covariance matrix. Use in conjuntion with Sigma to define effect and effect.measure.}

\item{Sigma}{population covariance matrix. Use in conjuntion with SigmaHat to define effect and effect.measure.}
}
\value{
list
}
\description{
Determine required sample size given alpha, beta/power, df, and effect
}
\examples{
\dontrun{
power <- semPower.aPriori(effect = .05, effect.measure = "RMSEA", alpha = .05, beta = .05, df = 200)
power
power <- semPower.aPriori(effect = .15, effect.measure = "F0", alpha = .05, power = .80, df = 100)
power
power <- semPower.aPriori(alpha = .01, beta = .05, df = 5, 
                          SigmaHat = diag(4), Sigma = cov(matrix(rnorm(4*1000),  ncol=4)))
power
}
}
