% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementInteraction.R, R/elementInteractionDoc.R
\name{elementSendKeys}
\alias{elementSendKeys}
\title{Send a sequence of key strokes to an element.}
\usage{
elementSendKeys(webElem, ...)
}
\arguments{
\item{webElem}{An object of class "wElement". A web Element object see \code{\link{wbElement}}.}

\item{...}{keys to send the element. \code{seleniumPipes} includes mappings to unicode keys see \code{\link{selKeys}}. To use one of this name the string using key. See examples.}
}
\value{
invisible(webElem): An object of class "wElement" is invisibly returned.
   A webElement object see \code{\link{wbElement}}. This allows for chaining from this function to
   other functions that take such an object as an argument. See examples for further details.
}
\description{
\code{elementSendKeys} The elementSendKeys function scrolls into view the form control element and then sends the provided keys to the element. In case the element is not keyboard interactable, an element not interactable error is returned.
}
\examples{
\dontrun{
  # start a brower
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  queryBox <- remDr \%>\% findElement("name", "q")

  # send text to the query box
  queryBox \%>\% elementSendKeys("Some ", "text")

  # clear the query box
  queryBox \%>\% elementClear

  # get the search button
  searchBtn <- remDr \%>\% findElement("name", "btnG")
  # send text to query box
  queryBox \%>\% elementSendKeys("R project")

  # click the search button
  searchBtn \%>\% elementClick

  # close browser
  remDr \%>\% deleteSession
}
}
\seealso{
Other elementInteraction functions: \code{\link{elementClear}},
  \code{\link{elementClick}}
}

