% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{segplot}
\alias{segplot}
\title{A visual representation of segregation}
\usage{
segplot(
  data,
  group,
  unit,
  weight,
  order = "segregation",
  reference_distribution = NULL,
  bar_space = 0,
  title = NULL,
  axis_labels = "left"
)
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the first dimension
over which segregation is computed.}

\item{unit}{A categorical variable or a vector of variables
contained in \code{data}. Defines the second dimension
over which segregation is computed.}

\item{weight}{Numeric. (Default \code{NULL})}

\item{order}{A character, either
"segregation", "entropy", "majority", or "majority_fixed".
Affects the ordering of the units.
The horizontal ordering of the groups can be changed
by using a factor variable for \code{group}.
The difference between "majority" and "majority_fixed" is that the former
will reorder the groups in such a way that the majority group actually comes first.
If you want to control the ordering yourself, use "majority_fixed" and specify
the \code{group} variable as a factor variable.}

\item{reference_distribution}{Specifies the reference distribution, given as
a two-column data frame, to be plotted on the right.
If order is \code{segregation}, then this reference distribution is
also used to compute the local segregation scores.}

\item{bar_space}{Specifies space between single units.}

\item{title}{Adds a plot title and appends the value of the H index.}

\item{axis_labels}{One of "left", "right", or "both". Determines where the
y axis labels are placed.}
}
\value{
Returns a ggplot2 object.
}
\description{
Produces a segregation plot.
}
