% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segregation.R
\name{matrix_to_long}
\alias{matrix_to_long}
\title{Turns a contingency table into long format}
\usage{
matrix_to_long(
  matrix,
  group = "group",
  unit = "unit",
  weight = "n",
  drop_zero = TRUE
)
}
\arguments{
\item{matrix}{A matrix, where the rows represent the units, and the
column represent the groups.}

\item{group}{Variable name for group. (Default \code{group})}

\item{unit}{Variable name for unit. (Default \code{unit})}

\item{weight}{Variable name for frequency weight. (Default \code{weight})}

\item{drop_zero}{Drop unit-group combinations with zero weight. (Default \code{TRUE})}
}
\value{
A data.table.
}
\description{
Returns a data.table in long form, such that it is suitable
for use in \link{mutual_total}, etc. Colnames and rownames of
the matrix will be respected.
}
\examples{
m = matrix(c(10, 20, 30, 30, 20, 10), nrow = 3)
colnames(m) <- c("Black", "White")
long = matrix_to_long(m, group = "race", unit = "school")
mutual_total(long, "race", "school", weight = "n")
}
