% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{segmentation_internal}
\alias{segmentation_internal}
\title{Internal segmentation function}
\usage{
segmentation_internal(x, seg.var = NULL, diag.var = NULL,
  order.var = NULL, scale.variable = NULL, Kmax, lmin = NULL,
  dat = NULL, type = NULL, sameSigma = F, subsample_over = 10000,
  subsample = TRUE, subsample_by = NA, ...)
}
\arguments{
\item{x}{data.frame with observations}

\item{seg.var}{for behavioral segmentation: names of the variables used for
segmentation (either one or two names).}

\item{diag.var}{for behavioral segmentation: names of the variables on which
statistics are calculated.}

\item{order.var}{for behavioral segmentation: names of the variable with
which states are ordered.}

\item{scale.variable}{should variables be standardized ? (reduced and centered)}

\item{Kmax}{maximum number of segments.}

\item{lmin}{minimum length of segments.}

\item{dat}{bivariate data (one signal per row)}

\item{type}{type of segmentation. Either "home-range" or "behavior". Changes
default values of arguments order, scale.variable in the different
functions used on the output. Default for segmentation: "home-range";
default for segmentation/clustering : "behavior".}

\item{sameSigma}{does segments have same variance ?}

\item{subsample_over}{over which size should subsampling begin (depending on
speed and memory limitations)}

\item{subsample}{if FALSE disable subsample}

\item{subsample_by}{override subsample_over to adjust manually subsampling}

\item{...}{additionnal parameters given to \link{chooseseg_lavielle}}
}
\description{
Internal segmentation function
}
