\name{Wrappers F and C}
\alias{cerio.F}
\alias{semi.F}
\alias{zelig.F}
\alias{river.C}
\alias{forsucc.C}

\title{
Wrapper for simulation programs in Fortran and C
}
\description{
Call to programs in Fortran and C using .Fortran and .C interfaces
}
\usage{
cerio.F(x, fileprefix)
semi.F(x, fileprefix)
zelig.F(x, fileprefix)
river.C(x, fileprefix)
forsucc.C(x, fileprefix)
}
\arguments{
  \item{x}{work directory name}
  \item{fileprefix}{prefix to build filename}
}
\details{
Programs written in Fortran and C are executed from an interface R function. These are dynamically loaded by useDynLib(seem) when loading seem. Alternatively, this dll can be loaded before using those programs by executing function dyn.load() in the following manner \code{>dyn.load(paste(.libPaths(),"/seem/libs/i386/seem.dll",sep=""))}
}

\value{
\code{fileout} is the name of output file generated by the Fortran or C program and renamed according to arguments to the wrapper. 
}

\references{
Acevedo M.F. 2012. Simulation of Ecological and Environmental Models. CRC Press.
}
\author{
Miguel F. Acevedo \email{Acevedo@unt.edu}
}

\note{
Alternatively, you can add dyn.load to the Rprofile.site file to load seem.dll automatically every time you start R.

The zelig model used here is based on the 2.3 version by D.L. Urban.
}

\seealso{
Interface functions \code{\link{.Fortran}}, \code{\link{.C}}, Output processor functions \code{\link{read.plot.cerio.out}}, \code{\link{read.plot.semi.out}},  \code{\link{read.plot.zelig.out}}, \code{\link{read.plot.river.out}}, \code{\link{read.plot.forsucc.out}}
}
\examples{
\dontrun{
is.loaded("cerio", PACKAGE="seem")

fileout <- cerio.F("chp10","cerio")
x <- read.plot.cerio.out(fileout,pdfout=TRUE)

is.loaded("river", PACKAGE="seem")
fileout <- river.C("chp14","river-sens")
x <- read.plot.river.out(fileout,sens=TRUE)

spp <- c("Post oak", "Black jack oak", "Winged elm", "GreenAsh",
         "CedarElm", "Hackberry", "BurOak", "Pecan")
grp1 <- c(1:3); grp2 <- c(4:8) #upland 3 spp and bottomland 5 spp

is.loaded("zelig", PACKAGE="seem")
fileout <- zelig.F("chp16","gbc")
x <- read.plot.zelig.out(fileout,spp, grp1, grp2)

fileout <- forsucc.C("chp16","forsucc") # forsucc is fileprefix
x <- read.plot.forsucc.out(fileout, sens=FALSE)

spp <- c("Role1", "Role2", "Role3", "Role4")
fileprefix <- "rolesm"; label <- "Semi-Markov Order 1" 
fileout <- semi.F("chp16",fileprefix)
x <- read.plot.semi.out(fileout, spp, label)

}
}
\keyword{ math }
\keyword{ IO }
