% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/Class-Pattern.R
\docType{class}
\name{Pattern-class}
\alias{Pattern}
\alias{Pattern-class}
\alias{pattern}
\alias{pattern.Pattern}
\alias{pattern.Searchable}
\alias{pattern.character}
\alias{pattern.default}
\alias{show,Pattern-method}
\title{Defines or extract a search pattern}
\usage{
pattern(object, type, ...)

\method{pattern}{default}(object = NULL, type = "std", ...)

\method{pattern}{character}(object, type = "std", ...)

\method{pattern}{Pattern}(object, type = object@type, ...)

\method{pattern}{Searchable}(object, type = object@type, ...)

\S4method{show}{Pattern}(object)
}
\arguments{
\item{object}{character or pattern;}

\item{type}{character; the type of match: std (default), regex, coll,
fixed.}

\item{...}{additional arguments to be passed to \code{stri_opts_*} functions.
       See details.

The \strong{pattern} class defines how the search is conducted.

The function \code{pattern} is the constructor for the class. It takes a
\code{'string'} can be used to define a pattern that controls matching
against a searchable target. Most often the user will want to use the type
specific functions: \code{regex}, \code{coll}, \code{fixed} or \code{basic}.
Eacb is described below.

These are closely related to the}
}
\description{
Patterns defines how searches are conducted against a searchable target
}
\section{Slots}{

\describe{
\item{\code{.Data}}{character object representing a pattern.}

\item{\code{type}}{character; type of search performed; one of "std" (default), "regex",
     "fixed", "coll", or "charclass". See details.}

\item{\code{options}}{list; name = value pairs for search options used.}
}}
\section{std}{


The default is \code{std} matching which performs matching
as base R would. This is equivalent to \code{fixed} and
\code{case_insensitive = FALSE}. Though the internal matching is sed.
}

\section{regex}{


\code{regex} matching takes a regular expression for matching using

\code{stri_*_regex} functions.
}

\section{coll}{

...
}

\section{fixed}{

...
}
\examples{
pattern('hello')
  pattern('hello', type="regex", boundary="starts_with" )
}

