% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratification.R
\name{discretize_vector}
\alias{discretize_vector}
\title{discretization}
\usage{
discretize_vector(
  x,
  n,
  method = "natural",
  breakpoint = NULL,
  sampleprob = 0.15,
  seed = 123456789
)
}
\arguments{
\item{x}{A continuous numeric vector.}

\item{n}{(optional) The number of discretized classes.}

\item{method}{(optional) The method of discretization, default is \code{natural}.}

\item{breakpoint}{(optional) Break points for manually splitting data. When
\code{method} is \code{manual}, \code{breakpoint} is required.}

\item{sampleprob}{(optional) When the data size exceeds \code{3000}, perform sampling
for discretization, applicable only to natural breaks. Default is \code{0.15}.}

\item{seed}{(optional) Random seed number, default is \code{123456789}.}
}
\value{
A discretized integer vector
}
\description{
discretization
}
\examples{
xvar = c(22361, 9573, 4836, 5309, 10384, 4359, 11016, 4414, 3327, 3408,
         17816, 6909, 6936, 7990, 3758, 3569, 21965, 3605, 2181, 1892,
         2459, 2934, 6399, 8578, 8537, 4840, 12132, 3734, 4372, 9073,
         7508, 5203)
discretize_vector(xvar, n = 5, method = 'natural')

}
