% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dharma.R
\name{dharma_residuals}
\alias{dharma_residuals}
\title{DHARMa residuals}
\usage{
dharma_residuals(
  simulated_response,
  object,
  plot = TRUE,
  return_DHARMa = FALSE,
  test_uniformity = TRUE,
  test_outliers = FALSE,
  test_dispersion = FALSE,
  ...
)
}
\arguments{
\item{simulated_response}{Output from \code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}}. It is recommended
to set \code{type = "mle-mvn"} in the call to \code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}} for the
residuals to have the expected distribution.}

\item{object}{Output from \code{\link[=sdmTMB]{sdmTMB()}}.}

\item{plot}{Logical. Calls \code{\link[DHARMa:plotQQunif]{DHARMa::plotQQunif()}}.}

\item{return_DHARMa}{Logical. Return object from \code{\link[DHARMa:createDHARMa]{DHARMa::createDHARMa()}}?}

\item{test_uniformity}{Passed to \code{testUniformity} in \code{\link[DHARMa:plotQQunif]{DHARMa::plotQQunif()}}.}

\item{test_outliers}{Passed to \code{testOutliers} in \code{\link[DHARMa:plotQQunif]{DHARMa::plotQQunif()}}.}

\item{test_dispersion}{Passed to \code{testDispersion} in \code{\link[DHARMa:plotQQunif]{DHARMa::plotQQunif()}}.}

\item{...}{Other arguments to pass to \code{\link[DHARMa:createDHARMa]{DHARMa::createDHARMa()}}.}
}
\value{
A data frame of observed and expected values is invisibly returned
so you can assign the output to an object and
plot the residuals yourself. See the examples.

If \code{return_DHARMa = TRUE}, the object from \code{DHARMa::createDHARMa()}
is returned and any subsequent \pkg{DHARMa} functions can be applied.
}
\description{
Plot (and possibly return) \pkg{DHARMa} residuals. This is a wrapper function
around \code{\link[DHARMa:createDHARMa]{DHARMa::createDHARMa()}} to facilitate its use with \code{\link[=sdmTMB]{sdmTMB()}} models.
\strong{Note:} It is recommended to set \code{type = "mle-mvn"} in
\code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}} for the resulting residuals to have the
expected distribution. This is \emph{not} the default.
}
\details{
See the \href{https://pbs-assess.github.io/sdmTMB/articles/residual-checking.html}{residuals vignette}.

Advantages to these residuals over the ones from the \code{\link[=residuals.sdmTMB]{residuals.sdmTMB()}}
method are (1) they work with delta/hurdle models for the combined
predictions, not the just the two parts separately, (2) they should work for
all families, not the just the families where we have worked out the
analytical quantile function, and (3) they can be used with the various
diagnostic tools and plots from the \pkg{DHARMa} package.

Disadvantages are (1) they are slower to calculate since one must first
simulate from the model, (2) the stability of the distribution of the
residuals depends on having a sufficient number of simulation draws, (3)
uniformly distributed residuals put less emphasis on the tails visually
than normally distributed residuals
(which may or may not be desired).

Note that \pkg{DHARMa} returns residuals that are uniform(0, 1) if the data
are consistent with the model whereas randomized quantile residuals from
\code{\link[=residuals.sdmTMB]{residuals.sdmTMB()}} are expected to be normal(0, 1).
}
\examples{
\dontshow{if (requireNamespace("DHARMa", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Try Tweedie family:
fit <- sdmTMB(density ~ as.factor(year) + s(depth, k = 3),
  data = pcod_2011, mesh = pcod_mesh_2011,
  family = tweedie(link = "log"), spatial = "on")

# The `simulated_response` argument is first so the output from
# simulate() can be piped to `dharma_residuals()`.

# We will work with 100 simulations for fast examples, but you'll
# likely want to work with more than this (enough that the results
# are stable from run to run).

# not great:
set.seed(123)
simulate(fit, nsim = 100, type = "mle-mvn") |>
  dharma_residuals(fit)

\donttest{
# delta-lognormal looks better:
set.seed(123)
fit_dl <- update(fit, family = delta_lognormal())
simulate(fit_dl, nsim = 100, type = "mle-mvn") |>
  dharma_residuals(fit)

# or skip the pipe:
set.seed(123)
s <- simulate(fit_dl, nsim = 100, type = "mle-mvn")
# and manually plot it:
r <- dharma_residuals(s, fit_dl, plot = FALSE)
head(r)
plot(r$expected, r$observed)
abline(0, 1)

# return the DHARMa object and work with the DHARMa methods
ret <- simulate(fit_dl, nsim = 100, type = "mle-mvn") |>
  dharma_residuals(fit, return_DHARMa = TRUE)
plot(ret)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=simulate.sdmTMB]{simulate.sdmTMB()}}, \code{\link[=residuals.sdmTMB]{residuals.sdmTMB()}}
}
