\name{gui}

\alias{gui}
\alias{gui,sdmModels-method}

  
\title{Graphical User Interface}

\description{
Provides the possibility of using functions in the package through an interactive graphical user interface (GUI). Depending on input, different GUIs are opened.
}

\usage{
\S4method{gui}{sdmModels}(x,...)

}

\arguments{
  \item{x}{a sdm* object}
  \item{...}{not implemented yet.}
}
\details{
When x is missing, a GUI is opened to facilitate all the steps required to create sdmData, specify the settings for the different steps, and fit sdm models.
Specifying x would be useful to interact with sdm* object. For example, if x is a \code{sdmModels} (that is generated by \code{sdm} function), a user can interactively explore the results (e.g., to see different plots of model evaluation results).
}

\value{
A HTML page in browser is opened.
}


\author{Babak Naimi \email{naimi.b@gmail.com}

\url{https://www.r-gis.net/}

\url{https://www.biogeoinformatics.org/}

}


\examples{
\dontrun{
file <- system.file("external/model.sdm", package="sdm")

m <- read.sdm(file) # a sdmModels Object (fitted using sdm function)

m

gui(m)

}

}

\keyword{spatial}
\keyword{interface}
