% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_dimVar.r, R/methods_class_dimVar.r
\docType{methods}
\name{get.dimVar}
\alias{get.dimVar}
\alias{get.dimVar,dimVar,character-method}
\title{query \code{dimVar}-objects depending on argument \code{type}}
\usage{
get.dimVar(object, type)

\S4method{get.dimVar}{dimVar,character}(object, type)
}
\arguments{
\item{object}{an object of class \code{dimVar}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item varName: variable name of the variable from which \code{object} was calculated
\item codesOriginal: original codes (as specified by the user)
\item codesDefault: calculated, default codes
\item codesMinimal: all codes required to calculate the complete hierarchy (no sub-totals)
\item levels: level-structure of the dimensional variable
\item structure: vector showing how many digits in the default codes are required for each level
\item dims: list showing the complete hierarchy of the dimensional variable
\item dups: vector of duplicated codes
\item dupsUp: vector of codes that are the 'upper' levels to which the codes in \code{dups} correspond
\item hasDuplicates: does the dimensional variable has codes that can be (temporarily) removed
\item nrLevels: the total number of levels of a dimensional variable
\item minimalCodesDefault: the standardized codes of the minimal set of required level-codes}
}
\value{
information from objects of class \code{dataObj} depending on argument \code{type}
\itemize{
\item a list if argument \code{type} matches 'dims'
\item numeric vector if argument \code{type} matches 'levels' or 'nrLevels'
\item character vector if argument \code{type} matches 'codesOriginal', 'codesDefault', 'vName', 'dups', 'dupsUp' or 'minimalCodesDefault'
\item logical vector of length 1 if argument \code{type} matches 'hasDuplicates'
\item a logical vector if argument \code{type} matches 'codesMinimal'}
}
\description{
query \code{dimVar}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

