% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_dataObj.r, R/methods_class_dataObj.r
\docType{methods}
\name{get.dataObj}
\alias{get.dataObj}
\alias{get.dataObj,dataObj,character-method}
\title{query \code{dataObj}-objects depending on argument \code{type}}
\usage{
get.dataObj(object, type)

\S4method{get.dataObj}{dataObj,character}(object, type)
}
\arguments{
\item{object}{an object of class \code{dataObj}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item rawData: raw input data
\item dimVarInd: indices of dimensional variables
\item freqVarInd: index of frequency variable
\item numVarInd: indices of numerical variables
\item weightVarInd index of weight variable
\item sampWeightInd index of variable holding sampling weights
\item isMicroData does \code{object} consist of microdata?
\item numVarNames variable names of numerical variables
\item freqVarName variable name of frequency variable
\item varName variable names of dimensional variables}
}
\value{
information from objects of class \code{dataObj} depending on argument \code{type}
\itemize{
\item a list if argument \code{type} matches 'rawData'
\item numeric vector if argument \code{type} matches 'dimVarInd', 'freqVarInd', 'numVarInd', 'weightVarInd' or 'sampWeightInd'
\item character vector if argument \code{type} matches 'numVarNames', 'freqVarName' or 'varName'
\item logical vector of length 1 if argument \code{type} matches 'isMicroData'}
}
\description{
query \code{dataObj}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

