% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUIfunctions.R
\name{writeSafeFile}
\alias{writeSafeFile}
\title{writeSafeFile}
\usage{
writeSafeFile(obj, format, randomizeRecords, fileOut, ...)
}
\arguments{
\item{obj}{an object of class \code{\link{data.frame}} containing micro data}

\item{format}{(character) specifies the output file format. Accepted values are:
\itemize{
\item {'rdata'}{ output will be saved in the R binary file-format.}
\item {'sav'}{ output will be saved as SPSS-file.}
\item {'dta'}{ ouput will be saved as STATA-file.}
\item {'csv'}{ output will be saved as comma seperated (text)-file.}}}

\item{randomizeRecords}{(logical) specifies, if the output records should be randomized. The following
options are possible:
\itemize{
\item {'no'}{ default, no randomization takes place}
\item {'simple'}{ records are just randomly swapped.}
\item {'byHH'}{ if slot 'hhId' is not \code{NULL}, the clusters defined by this variable are randomized across the dataset. If
slot 'hhId' is \code{NULL}, the records or the dataset are randomly changed.}
\item {'withinHH'}{ if slot 'hhId' is not \code{NULL}, the clusters defined by this variable are randomized across the dataset and
additionally, the order of records within the clusters are also randomly changed. If slot 'hhId' is \code{NULL}, the records or the dataset are
randomly changed.}}}

\item{fileOut}{(character) file to which output should be written}

\item{...}{optional arguments used for \code{write.table} if argument \code{format} equals \code{csv}}
}
\description{
writes an anonymized dataset to a file. This function should be used in the
graphical user interface \code{\link{sdcApp}} only.
}
\author{
Bernhard Meindl
}

