\name{A5. Estimate the model}
\alias{A5. Estimate the model}
\alias{scp}
\title{
Spatial smoothing with unknown changes in the pattern of response
}
\description{
Fit a spatial semiparametric model based on splines including unknown changes in the pattern of response.
}
\usage{
scp(formula, data, initial = NULL, contrasts = NULL,
        model = "exponential", fix.nugget = FALSE, fix.kappa = FALSE,
        nugget.tol = 1e-15, angle = 0, ratio = 1, use.reml = FALSE,
        use.profile = TRUE, chMaxiter = 20, control = list())
}
\arguments{
	\item{formula}{
		formula. An expression to specify the model to fit. See \emph{2. Mean model}.
	}
	\item{data}{
		sss class object. A dataset object generated by any of the commands \link{as.sss} or \link{create.sss}.
	}
	\item{initial}{
		named list. The starting values for the covariance parameters of the model. If \code{initial=NULL} then it is used an internal grid search to define the starting values.
	}
	\item{contrasts}{
		character. A contrast method for factor covariates. Default to \samp{contr.treatment}.
	}
	\item{model}{
		character. Name of the semivariogram model to estimate for the spatial dependence. See \emph{Semivariogram Model}.
	}
	\item{fix.nugget}{
		logical or numeric. If \code{FALSE} the nugget \eqn{\tau^2} is estimated. If \code{fix.nugget} is a numeric value then the nugget \eqn{\tau^2} is set to the value defined for \code{fix.nugget}.
	}
	\item{fix.kappa}{
		logical or numeric vector. If \code{FALSE} the parameters \eqn{\kappa} are estimated. If \code{fix.kappa} is a numeric vector then \eqn{\kappa} is set to the values of the vector defined for \code{fix.kappa}.
	}
	\item{nugget.tol}{
		numeric. Threshold for microscale spatial variations to define the nugget effect. Default to \code{1.0e-15}. Do not modify unless know what is being doing.
	}
	\item{angle}{
		numeric. Angle for geometric anisotropy. Note that this overwrites any specification for \code{aniso.angle} in \link{s2D}.
	}
	\item{ratio}{
		numeric. Ratio between \eqn{[0,1]} for geometric anisotropy. Note that this overwrites any specification for \code{aniso.ratio} in \link{s2D}.
	}
	\item{use.reml}{
		logical. For using REML estimation set to \code{TRUE}, for ML estimation set to \code{FALSE} (default).
	}
	\item{use.profile}{
		logical. For profiling set to \code{TRUE} (default).
	}
	\item{chMaxiter}{
		integer. Maximum number of iterations for the loop estimating changes in the pattern of response.
	}
	\item{control}{
		named list. Options to control the optimization. See argument \command{control} in command \link{optim}.
	}

}
\author{
Mario A. Martinez Araya, \email{r@marioma.me}
}
\section{1. Semiparametric model}{
Assume that the response variable admit the trend surface model \deqn{Y(s) = a^T b + g(s) + \epsilon(s)} where \eqn{a} is a known vector of covariates and \eqn{b} their coefficients; \eqn{g(s)} is a deterministic bivariate spline and \eqn{\epsilon(s)} is a Gaussian spatial process (GSP) with mean zero and covariance depending only on the distance \eqn{h} and given by \eqn{Cov(\epsilon(s+h),\epsilon(s))}. This model is also called a \emph{trend surface model}. Given \eqn{n} observed locations \eqn{s_1,\ldots,s_n\in S\subset\Re^2} in a two-dimensional space, then the model is \deqn{Y = Ab + g + \epsilon} where \eqn{Y = (Y(s_1), \ldots, Y(s_n))^T}, \eqn{A} is the known matrix of covariates, \eqn{g = (g(s_1),\ldots,g(s_n))^T} and \eqn{\epsilon = (\epsilon(s_1),\ldots,\epsilon(s_n))^T}. The covariance matrix is given by \eqn{Cov(\epsilon,\epsilon) = \Sigma = \sigma^2 R} with \eqn{R} a valid correlation matrix. Thus \eqn{Y\sim N_n(\mu,\Sigma)} where \eqn{\mu = Ab + g} and the likelihood function is \eqn{L(b,g,\sigma^2,\theta;Y) = (2\pi)^{-n/2}|\Sigma|^{-1/2}\exp\{-\frac{1}{2}(Y-\mu)^T\Sigma^{-1}(Y-\mu)\}} with \eqn{\theta} the parameters that define the correlation matrix \eqn{R}.
}
\section{2. Mean model}{
It can be defined by the commands:
	\describe{
		\item{\command{linear}}{that defines the covariates in the matrix \eqn{A}. Note that more than one \command{linear} command can be defined. See \link{linear}.}
		\item{\command{cp}}{defines changes in the pattern of response by including the covariates \eqn{(z_d - \psi^{(0)}_d)\times 1\{z_d>\psi^{(0)}_d\}} and \eqn{-1\{z_d>\psi^{(0)}_d\}} for \eqn{d=1,\ldots,G} into the matrix \eqn{A}. Note that more than one \command{cp} command can be defined. See \link{cp}.}
		\item{\command{s2D}}{define the bivariate spline \eqn{g}. Note that only one \command{s2D} command can be defined. See \link{s2D}.}
	}
}
\section{3. Covariance model and nugget effect}{
Given a distance \eqn{h} define \eqn{u = ||T^{1/2}_{\texttt{\tiny angle, ratio}}h|| = (h^T T_{\texttt{\tiny angle,ratio}} h)^{1/2}\in\Re} where \eqn{T_{\texttt{\tiny angle, ratio}}} is a rotation matrix for geometric anisotropy.
The errors are given by the process \eqn{\epsilon(s) = \eta(s) + \xi(s)} where \eqn{\xi} is a GSP with mean zero and covariance \deqn{\begin{array}{ll}Cov(\xi(s),\xi(s+h)) & = C_\xi(u;\phi,\kappa) \\ & = \sigma^2_0\rho_\xi(u;\phi,\kappa)\end{array}} with \eqn{\rho_\xi(u;\phi,\kappa)} the correlation function; and \eqn{\eta} is a nugget effect with covariance \deqn{\begin{array}{ll}Cov(\eta(s),\eta(s+h)) & = C_\eta(u;\tau^2,\texttt{tol.nugget}) \\ & = \tau^2\rho_\eta(u;\texttt{tol.nugget})\end{array}} with correlation function \eqn{\rho_\eta(u;\texttt{tol.nugget}) = 1\{u<\texttt{tol.nugget}\}}. Therefore the covariance of the process \eqn{\epsilon} is given by \deqn{\begin{array}{ll} Cov(\epsilon(s),\epsilon(s+h)) & = C_\epsilon(u;\sigma^2,\theta,\texttt{tol.nugget}) \\ & = \sigma^2 \rho_\epsilon(u;\theta,\texttt{tol.nugget})\end{array}} with correlation function given by \deqn{\rho_\epsilon(u;\theta,\texttt{tol.nugget}) = (1-\rho_*)\rho_\eta(u;\texttt{tol.nugget}) + \rho_*\rho_\xi(u;\phi,\kappa)} where \eqn{\theta = (\rho_*,\phi,\kappa)^T} are the parameters with \eqn{\rho_* = \sigma^2_0/\sigma^2}, \eqn{\sigma^2 = \tau^2 + \sigma^2_0}, and \code{tol.nugget} is the argument that controls the largest distance at which micro-scale variations can affect the observed outcome. By default \code{tol.nugget} is set to \code{1.0e-15}. The parameters \eqn{\phi,\kappa} define the correlation function of the process \eqn{\xi} with \eqn{\phi} usually called the \emph{range parameter} and \eqn{\kappa} depending on the model selected. The semivariogram can be expressed as \deqn{\gamma_\epsilon(u;\sigma^2,\theta,\texttt{tol.nugget}) = \sigma^2(1-\rho_\epsilon(u;\theta,\texttt{tol.nugget}))} where \eqn{\tau^2} is the nugget effect, \eqn{\sigma^2} is the sill, and \eqn{\sigma^2_0} is the partial sill.
Note that when \code{angle = 0} and \code{ratio = 1} the matrix \eqn{T_{\texttt{\tiny angle,ratio}}} is an identity matrix and \eqn{u = h} so the correlation \eqn{\rho_\epsilon(u;\theta,\texttt{tol.nugget})} is isotropic. Use different values for \code{angle} and \code{ratio} to define a geometric anisotropic correlation function. Then the covariance matrix \eqn{\Sigma = \sigma^2 R} where \eqn{R} is the correlation matrix originated from \eqn{\rho_\epsilon(u;\theta,\texttt{tol.nugget})}.
It is possible to define the argument \code{model=name} where \code{name} is one of the following: \samp{matern}, \samp{powered.exponential}, \samp{spherical}, \samp{wave}, \samp{exponential}, \samp{gaussian}, \samp{cubic}, \samp{circular}, \samp{gencauchy}, \samp{cauchy}, \samp{RMmatern}, \samp{RMwhittle}, \samp{RMgneiting}, and \samp{RMnugget}. For \code{.semiVar} one of \samp{matern}, \samp{gaussian}, \samp{exponential}, \samp{power}, \samp{cubic}, \samp{penta.spherical}, \samp{spherical}, \samp{wave}, \samp{sin.hole}, \samp{pure.nugget} and \samp{identity}. By default the covariance model is set to \samp{exponential} with \code{angle=0} and \code{ratio=1}.
}
\section{4. Penalized maximum likelihood estimation}{
Estimation can be performed by maximisation with respect to \eqn{b,g,\sigma^2,\theta}, and \eqn{\alpha} of the penalized log likelihood \deqn{\ell_p(b,g,\sigma^2,\theta,\alpha) = \log(L(b,g,\sigma^2,\theta;Y)) - \frac{1}{2\sigma^2} J_\alpha(g)} where \eqn{J_\alpha(g) = g^T Q_\alpha g} is the penalty and \eqn{Q_\alpha} is the roughness matrix.
}
\section{5. Penalties}{
Depending on the type of spline assumed for \eqn{g} the penalty is defined differently depending on the roughness matrix \eqn{Q_\alpha} which is given by:
	\describe{
		\item{\bold{Tensor product spline}.}{Given \eqn{\tau_{1,1},\ldots,\tau_{1,K_1}} and \eqn{\tau_{2,1},\ldots,\tau_{2,K_2}} the design points in each coordinate then \deqn{Q_\alpha = \alpha_1 I_{K_2}\otimes Q_1 + \alpha_2 Q_2\otimes I_{K_1}} where \eqn{Q_1}, \eqn{Q_2} are unidimensional roughness matrices from the design points in each coordinate and \eqn{\alpha_1}, \eqn{\alpha_2} are smoothing parameters in each direction.}
		\item{\bold{Thin plate spline}.}{Given the \eqn{n} locations, \eqn{Q_\alpha = \alpha E} where \eqn{\alpha} is the smoothing parameter and the \eqn{n\times n} matrix \eqn{E} has elements \eqn{E_{i,j} = \vartheta(||s_i - s_j||)} for \eqn{i,j=1,\ldots,n} where \deqn{\vartheta(u) = \left\{\begin{array}{ll}\frac{1}{16\pi}\times u^2\log(u^2) & \textrm{ , $u>0$} \\ 0 & \textrm{ , otherwise.}\end{array}\right.}}
	}
}
\section{6. Mixed model representation}{
The spline can be written as \eqn{g = X\beta + Zr} with \eqn{\beta} and \eqn{r} the coefficients and \eqn{X} and \eqn{Z} design matrices conveniently defined. Then for the observed responses the model can be expressed as a the mixed model \deqn{Y = Ab + X\beta + Zr + \epsilon} where \eqn{r \sim Normal(0,I_V)} with \eqn{V} the number of columns in \eqn{Z}. Then, \eqn{Y\sim N_n(\mu_m, \Sigma)} where \eqn{\mu_m = Ab + X\beta} and \eqn{\Sigma = \sigma^2 R}; and \eqn{Y|r \sim N_n(\mu,V)} where \eqn{\mu = Ab + X\beta + Zr} and \eqn{V = ZZ^T + \Sigma}. Let us denote \eqn{\vartheta = (b,\beta,\sigma^2,\theta,\alpha)^T}, then the conditional log-likelihood of the model is given by \deqn{\ell(\vartheta|r) \propto -\frac{1}{2}\left\{\log|\Sigma|+(Y-\mu)^T\Sigma^{-1}(Y-\mu)\right\}} and the marginal log-likelihood is given by \deqn{\ell(\vartheta) \propto -\frac{1}{2}\left\{\log|V|+(Y-Ab-X\beta)^T V^{-1}(Y-Ab-X\beta)\right\}.}
}

