% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{set_theme_element}
\alias{set_theme_element}
\title{Set a theme element}
\usage{
set_theme_element(object, ...)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{...}{various style parameter}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with a changed \code{theme}
element.
}
\description{
Set a theme element
}
\details{
Usually, you don't need this function. Possible theme elements are:
"text", "plot.background", "panel.background", "panel.spacing.y",
"dataline", "datapoint", "statline", "axis.expand.x", "axis.expand.y",
"axis.line.x", "axis.line.y", "axis.ticks.length", "axis.ticks",
"axis.title.y", "axis.title.x", "axis.text.x", "axis.text.y", "plot.title",
"plot.caption", "plot.margin", "casenames", "casenames.strip",
"casenames.background", "casenames.position", "phasenames",
"phasenames.position.x", "separators", "separators.extent", "label.text",
"label.background", "label.padding", "grid", "legend.position",
"legend.background", "legend.text", "legend.title", "legend.margin".

The elements are of the following classes:
\itemize{
\item text = c("element_text", "element"),
\item plot.background = c("element_rect", "element"),
\item panel.spacing.y = c("simpleUnit", "unit", "unit_v2"),
\item dataline = "list",
\item datapoint = "list",
\item statline = c("element_line", "element" ),
\item axis.expand.x = "numeric",
\item axis.expand.y = "numeric",
\item axis.line.x = c("element_line", "element"),
\item axis.line.y = c("element_line", "element"),
\item axis.ticks.length = c("simpleUnit", "unit", "unit_v2"),
\item axis.ticks = c("element_line", "element"),
\item axis.title.y = c("element_text", "element"),
\item axis.title.x = c("element_text", "element"),
\item axis.text.x = c("element_text", "element"),
\item axis.text.y = c("element_text", "element"),
\item plot.title = c("element_text", "element"),
\item plot.caption = c("element_text", "element"),
\item plot.margin = c("margin", "simpleUnit", "unit","unit_v2"),
\item casenames = c("element_text", "element"),
\item casenames.strip = c("element_rect", "element"),
\item casenames.background = c("element_rect", "element"),
\item casenames.position = "character",
\item phasenames = c("element_text", "element"),
\item phasenames.position.x = "character",
\item separators = c("element_line", "element"),
\item separators.extent = "character",
\item label.text = c("element_text", "element"),
\item label.background = c("element_rect", "element" ),
\item label.padding = "numeric", grid = c("element_line", "element" ),
\item legend.position = "character",
\item legend.background = c("element_rect",  "element"),
\item legend.text = c("element_text", "element"),
\item legend.title = c("element_text", "element"),
\item legend.margin = c("margin", "simpleUnit", "unit", "unit_v2")
}
}
\examples{
data(exampleABC, package = "scan")
p1 <- scplot(exampleABC)  |>
  set_theme_element(
    axis.ticks.length = unit(0, "points"),
    axis.line.y = element_line(color = "darkred", linewidth = 2),
    panel.background = element_rect(color = "darkblue", linewidth = 1),
    panel.spacing.y = unit(0, "points"),
    phasenames = element_text(color = "#00000000")
  )
}
