% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scpi-package.R
\docType{package}
\name{scpi-package}
\alias{scpi-package}
\alias{_PACKAGE}
\title{\code{scpi}: A Package to Compute Synthetic Control Prediction Intervals With Multiple Treated Units and Staggered Adoption}
\description{
The package implements estimation, inference procedures, and produces plots for Synthetic Control (SC) methods
using least squares, lasso, ridge, or simplex-type
constraints. Uncertainty is quantified using prediction intervals according to
\href{https://cattaneo.princeton.edu/papers/Cattaneo-Feng-Titiunik_2021_JASA.pdf}{Cattaneo, Feng, and Titiunik (2021)}.

Included functions are: \link{scdata} and \link{scdataMulti} for data preparation, \link{scest} for point estimation,
\link{scpi} for inference procedures, and \link{scplot} and \link{scplotMulti} for plots.

\code{print()} and \code{summary()} methods are available for \code{\link{scest}} and \code{\link{scpi}}.

Companion \href{https://www.stata.com/}{Stata} and \href{https://www.python.org/}{Python} packages are described in
\href{https://arxiv.org/abs/2202.05984}{Cattaneo, Feng, Palomba, and Titiunik (2022)}.

Related Stata, R, and Python packages useful for inference in SC designs are described in the following website:

\href{ https://nppackages.github.io/scpi/}{ https://nppackages.github.io/scpi/}

For an introduction to synthetic control methods, see \href{https://www.aeaweb.org/articles?id=10.1257/jel.20191450}{Abadie (2021)} and references therein.
}
\references{
\itemize{
\item{\href{https://www.aeaweb.org/articles?id=10.1257/jel.20191450}{Abadie, A. (2021)}. Using synthetic controls: Feasibility, data requirements, and methodological aspects.
\emph{Journal of Economic Literature}, 59(2), 391-425.}
\item{\href{https://cattaneo.princeton.edu/papers/Cattaneo-Feng-Titiunik_2021_JASA.pdf}{Cattaneo, M. D., Feng, Y., and Titiunik, R.
(2021)}. Prediction intervals for synthetic control methods. \emph{Journal of the American Statistical Association}, 116(536), 1865-1880.}
\item{\href{https://arxiv.org/abs/2202.05984}{Cattaneo, M. D., Feng, Y., Palomba F., and Titiunik, R. (2022).}
scpi: Uncertainty Quantification for Synthetic Control Methods, \emph{arXiv}:2202.05984.}
\item{\href{https://arxiv.org/abs/2210.05026}{Cattaneo, M. D., Feng, Y., Palomba F., and Titiunik, R. (2022).}
Uncertainty Quantification in Synthetic Controls with Staggered Treatment Adoption, \emph{arXiv}:2210.05026.}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://nppackages.github.io/scpi/}
}

}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Yingjie Feng, Tsinghua University. \email{fengyj@sem.tsinghua.edu.cn}.

Filippo Palomba, Princeton University (maintainer). \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}.
}
