% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-binary.R
\name{get_metrics.forecast_binary}
\alias{get_metrics.forecast_binary}
\title{Get default metrics for binary forecasts}
\usage{
\method{get_metrics}{forecast_binary}(x, select = NULL, exclude = NULL, ...)
}
\arguments{
\item{x}{A forecast object (a validated data.table with predicted and
observed values, see \code{\link[=as_forecast_binary]{as_forecast_binary()}}).}

\item{select}{A character vector of scoring rules to select from the list. If
\code{select} is \code{NULL} (the default), all possible scoring rules are returned.}

\item{exclude}{A character vector of scoring rules to exclude from the list.
If \code{select} is not \code{NULL}, this argument is ignored.}

\item{...}{unused}
}
\value{
A list of scoring functions.
}
\description{
For binary forecasts, the default scoring rules are:
\itemize{
\item "brier_score" = \code{\link[=brier_score]{brier_score()}}
\item "log_score" = \code{\link[=logs_binary]{logs_binary()}}
}
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-binary-point.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for binary and point forecasts
}
\if{latex}{
  \figure{metrics-binary-point.png}
}
}

\examples{
get_metrics(example_binary)
get_metrics(example_binary, select = "brier_score")
get_metrics(example_binary, exclude = "log_score")
}
\seealso{
Other get_metrics functions: 
\code{\link{get_metrics}()},
\code{\link{get_metrics.forecast_nominal}()},
\code{\link{get_metrics.forecast_ordinal}()},
\code{\link{get_metrics.forecast_point}()},
\code{\link{get_metrics.forecast_quantile}()},
\code{\link{get_metrics.forecast_sample}()},
\code{\link{get_metrics.scores}()}
}
\concept{get_metrics functions}
\keyword{handle-metrics}
