% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_score.R
\name{logs_binary}
\alias{logs_binary}
\title{Log Score for Binary outcomes}
\usage{
logs_binary(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n with
all values equal to either 0 or 1}

\item{predictions}{A vector with a predicted probability
that true_value = 1.}
}
\value{
A numeric value with the Log Score, i.e. the mean squared
error of the given probability forecasts
}
\description{
Computes the Log Score for probabilistic forecasts of binary outcomes.
}
\details{
The Log Score is a proper score rule suited to assessing the accuracy of
probabilistic binary predictions. The outcomes can be either 0 or 1,
the predictions must be a probability that the true outcome will be 1.

The Log Score is then computed as the negative logarithm of the probability
assigned to the true outcome. Reporting the negative logarithm means that
smaller values are better.
}
\examples{
true_values <- sample(c(0, 1), size = 30, replace = TRUE)
predictions <- runif(n = 30, min = 0, max = 1)
logs_binary(true_values, predictions)
}
\keyword{metric}
