% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sclr.R
\name{sclr}
\alias{sclr}
\title{Fits the scaled logit model}
\usage{
sclr(
  formula,
  data = NULL,
  ci_lvl = 0.95,
  tol = 10^(-7),
  algorithm = c("newton-raphson", "gradient-ascent"),
  nr_iter = 2000,
  ga_iter = 2000,
  n_conv = 3,
  conventional_names = FALSE,
  seed = NULL
)
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the
model to be fitted.}

\item{data}{a data frame.}

\item{ci_lvl}{Confidence interval level for the parameter estimates.}

\item{tol}{Tolerance.}

\item{algorithm}{Algorithms to run. "newton-raphson" or "gradient-ascent".
If a character vector, the algorithms will be applied in the order they
are present in the vector.}

\item{nr_iter}{Maximum allowed iterations for Newton-Raphson.}

\item{ga_iter}{Maximum allowed iterations for gradient ascent.}

\item{n_conv}{Number of times the algorithm has to converge (to work around
local maxima).}

\item{conventional_names}{If \code{TRUE}, estimated parameter names will be
(Baseline), (Intercept) and the column names in the model matrix. Otherwise
- lambda, beta_0 and beta_ prefix in front of column names in the model
matrix.}

\item{seed}{Seed for the algorithms.}
}
\value{
An object of class \code{sclr}. This is a list with the following
  elements:

  \item{parameters}{Maximum likelihood estimates of the parameter values.}

  \item{covariance_mat}{The variance-covariance matrix of the parameter
  estimates.}
  
  \item{algorithm}{Algorithm used.}
  
  \item{algorithm_return}{Everything the algorithm returned.}

  \item{n_converge}{The number of Newton-Raphson iterations (including
  resets) that were required for convergence.}

  \item{x}{Model matrix derived from \code{formula} and \code{data}.}

  \item{y}{Response matrix derived from \code{formula} and \code{data}.}

  \item{call}{The original call to \code{sclr}.}

  \item{model}{Model frame object derived from \code{formula} and
  \code{data}.}

  \item{terms}{Terms object derived from model frame.}

  \item{ci}{Confidence intervals of the parameter estimates.}

  \item{log_likelihood}{Value of log-likelihood calculated at the ML
  estimates of parameters.}
  
  \item{formula}{Passed formula.}
  
  \item{data}{Passed data.}

  Methods supported: \code{\link[=print.sclr]{print}},
  \code{\link[=vcov.sclr]{vcov}}, \code{\link[=coef.sclr]{coef}},
  \code{\link[=model.frame.sclr]{model.frame}},
  \code{\link[=model.matrix.sclr]{model.matrix}},
  \code{\link[=summary.sclr]{summary}}, \code{\link[=predict.sclr]{predict}},
  \code{\link[=tidy.sclr]{tidy}} (\code{\link{broom}} package),
  \code{\link[=logLik.sclr]{logLik}}.
}
\description{
Used to fit the scaled logit model from Dunning (2006).
}
\details{
The model is logistic regression with an added parameter for the top
asymptote. That parameter is reported as \code{theta} (or \code{(Baseline)}
if \code{conventional_names = TRUE}). Note that it is reported on the logit
scale. See \code{vignette("sclr-math")} for model specification,
log-likelihood, scores and second derivatives. The main default optimisation
algorithm is Newton-Raphson. Gradient ascent is used as a fallback by
default. Computing engine behind the fitting is \code{\link{sclr_fit}}.
}
\examples{
library(sclr)
fit1 <- sclr(status ~ logHI, one_titre_data)
summary(fit1)
}
\references{
Dunning AJ (2006). "A model for immunological correlates of
  protection." Statistics in Medicine, 25(9), 1485-1497.
  \url{https://doi.org/10.1002/sim.2282}.
}
