% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{sclr_fit}
\alias{sclr_fit}
\title{Fitter function for the scaled logit model}
\usage{
sclr_fit(y, x, tol = 10^(-7), n_iter = NULL, max_tol_it = 10^4)
}
\arguments{
\item{y}{A vector of observations.}

\item{x}{A design matrix.}

\item{tol}{Tolerance. Used when \code{n_iter} is \code{NULL}.}

\item{n_iter}{Number of Newton-Raphson iterations. \code{tol} is ignored when
this is not \code{NULL}.}

\item{max_tol_it}{Maximum tolerated iterations. If it fails to converge 
within this number of iterations, will return with an error.}
}
\description{
Computing engine behind \code{\link{sclr}}.
}
\details{
The likelihood maximisation uses the
Newton-Raphson algorithm. Initial values are always 1 for the covariate
coefficients (and the associated intercept) and the proportion of infected
for the baseline risk. The algorithm will pick a new guess and restart 
under a set of conditions.
1) Algorithm's iteration produces estimate guesses that
cannot be used - baseline risk outside of (0, 1) (likelihood undefined). 
2) The second derivative matrix produced by the current estimates 
is "bad" - positive diagonal or missing values due to failing large 
number calculations
}
