% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handout.R, R/html.R, R/utils.R
\name{handout}
\alias{handout}
\alias{book}
\alias{html}
\alias{newthought}
\alias{margin_note}
\alias{quote_footer}
\alias{sans_serif}
\title{Scientific handout formats (PDF and HTML)}
\usage{
handout(
  fig_width = 4,
  fig_height = 2.5,
  fig_crop = TRUE,
  dev = "pdf",
  highlight = "default",
  ...
)

book(
  fig_width = 4,
  fig_height = 2.5,
  fig_crop = TRUE,
  dev = "pdf",
  highlight = "default",
  ...
)

html(...)

newthought(text)

margin_note(text, icon = "&#8853;")

quote_footer(text)

sans_serif(text)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_crop}{Whether to crop PDF figures with the command
\command{pdfcrop}. This requires the tools \command{pdfcrop} and
\command{ghostscript} to be installed. By default, \code{fig_crop = TRUE}
if these two tools are available.}

\item{dev}{Graphics device to use for figure output (defaults to pdf)}

\item{highlight}{Syntax highlighting style passed to Pandoc.

 Supported built-in styles include "default", "tango", "pygments", "kate",
 "monochrome", "espresso", "zenburn", "haddock", and "breezedark".

  Two custom styles are also included, "arrow", an accessible color scheme,
  and "rstudio", which mimics the default IDE theme. Alternatively, supply a
  path to a \samp{.theme} file to use
  \href{https://pandoc.org/MANUAL.html#syntax-highlighting}{a custom Pandoc
  style}. Note that custom theme requires Pandoc 2.0+.

  Pass \code{NULL} to prevent syntax highlighting.}

\item{...}{Other arguments to be passed to \code{\link[=pdf_document]{pdf_document()}} or
\code{\link[=html_document]{html_document()}} (note you cannot use the \code{template}
argument in \code{handout} or the \code{theme} argument in
\code{html()}; these arguments have been set internally)}

\item{text}{A character string to be presented as a \dQuote{new thought}
(using small caps), or a margin note, or a footer of a quote}

\item{icon}{A character string to indicate there is a hidden margin note when
the page width is too narrow (by default it is a circled plus sign)}
}
\value{
a PDF or HTML notebook output based on the R markdown document provided
}
\description{
Template for creating scientific handout
}
\details{
\code{handout()} provides the PDF format

\code{html()} provides the HTML format based on the scientific CSS

\code{newthought()} can be used in inline R expressions in R
Markdown

\if{html}{\out{<div class="sourceCode r">}}\preformatted{`r newthought(Some text)`
}\if{html}{\out{</div>}}

and it works for both
HTML (\samp{<span class="newthought">text</span>}) and PDF
(\samp{\\newthought{text}}) output.

\code{margin_note()} can be used in inline R expressions to write a
margin note (like a sidenote but not numbered).

\code{quote_footer()} formats text as the footer of a quote. It puts
\code{text} in \samp{<footer></footer>} for HTML output, and
after \samp{\\hfill} for LaTeX output (to right-align text).

\code{sans_serif()} applies sans-serif fonts to \code{text}.
}
\examples{
\dontrun{
# for Rmd to PDF
library(rmarkdown)
library(scientific)
rmdfile <- "input.Rmd"
rmarkdown::render(rmdfile,
  scientific::handout())
}

\dontrun{
# for Rmd to HTML
library(rmarkdown)
library(scientific)
rmdfile <- "input.Rmd"
rmarkdown::render(rmdfile,
  scientific::html(
    toc = TRUE,
    toc_depth = 2))
}
newthought("In this section")
}
