% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_tax.R
\name{read_tax}
\alias{read_tax}
\title{Read in a taxonomy file and parse it to a wide dataframe}
\usage{
read_tax(taxonomy_filename, sep = "\\t")
}
\arguments{
\item{taxonomy_filename}{filename of taxonomy file}

\item{sep}{Character that separates fields of the taxonomy file. (Default: \verb{\\t}).}
}
\value{
dataframe of taxonomic labels, formatted by \code{parse_tax()}
}
\description{
Read in a taxonomy file and parse it to a wide dataframe
}
\examples{
taxonomy_filepath <- system.file("extdata",
  "test.taxonomy",
  package = "schtools"
)
taxonomy_tbl <- read_tax(taxonomy_filepath)
head(taxonomy_tbl)
}
\author{
Nick Lesniak, \email{nlesniak@umich.edu}

Kelly Sovacool, \email{sovacool@umich.edu}
}
