% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{propagate_labels}
\alias{propagate_labels}
\title{Label propagation}
\usage{
propagate_labels(
  edge_verts,
  edge_weights,
  vert_labels,
  max_n_iters = 10L,
  verbose = TRUE,
  diffusion_fading = 10,
  diffusion_fading_const = 0.5,
  tol = 0.005,
  fixed_initial_labels = FALSE
)
}
\arguments{
\item{edge_verts}{edge vertices of igraph graph object}

\item{edge_weights}{edge weights of igraph graph object}

\item{vert_labels}{vector of factor or character labels, named by cell names}

\item{max_n_iters}{integer Maximal number of iterations (default=10)}

\item{verbose}{boolean Verbose mode (default=TRUE)}

\item{diffusion_fading}{numeric Constant used for diffusion on the graph, exp(-diffusion.fading * (edge_length + diffusion.fading.const)) (default=10.0)}

\item{diffusion_fading_const}{numeric Another constant used for diffusion on the graph, exp(-diffusion.fading * (edge_length + diffusion.fading.const)) (default=0.5)}

\item{tol}{numeric Absolute tolerance as a stopping criteria (default=5e-3)}

\item{fixed_initial_labels}{boolean Prohibit changes of initial labels during diffusion (default=FALSE)}
}
\value{
matrix from input graph, with labels propagated
}
\description{
Label propagation
}
