% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{plapply}
\alias{plapply}
\title{Parallel, optionally verbose lapply. See ?parallel::mclapply for more info.}
\usage{
plapply(
  ...,
  progress = FALSE,
  n.cores = parallel::detectCores(),
  mc.preschedule = FALSE,
  mc.allow.recursive = TRUE,
  fail.on.error = FALSE
)
}
\arguments{
\item{...}{Additional arguments passed to mclapply(), lapply(), or pbmcapply::pbmclapply()}

\item{progress}{Show progress bar via pbmcapply::pbmclapply() (default=FALSE).}

\item{n.cores}{Number of cores to use (default=parallel::detectCores()). When n.cores=1, regular lapply() is used. Note: doesn't work when progress=TRUE}

\item{mc.preschedule}{if set to \code{TRUE} then the computation is
    first divided to (at most) as many jobs are there are cores and then
    the jobs are started, each job possibly covering more than one
    value.  If set to \code{FALSE} then one job is forked for each value
    of \code{X}.  The former is better for short computations or large
    number of values in \code{X}, the latter is better for jobs that
    have high variance of completion time and not too many values of
    \code{X} compared to \code{mc.cores}.}

\item{mc.allow.recursive}{boolean Unless true, calling mclapply in a child process will use the child and not fork again (default=TRUE)}

\item{fail.on.error}{boolean Whether to fail and report and error (using stop()) as long as any of the individual tasks has failed (default =FALSE)}
}
\value{
list, as returned by lapply
}
\description{
Parallel, optionally verbose lapply. See ?parallel::mclapply for more info.
}
\examples{
square = function(x){ x**2 }
plapply(1:10, square, n.cores=1, progress=TRUE)

}
