% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fss_exponential_family.R
\name{exponential_priority}
\alias{exponential_priority}
\title{Compute exponential priority function values cumulatively over time.}
\usage{
exponential_priority(counts, baselines,
  scalar_priority_fun = exponential_qmax)
}
\arguments{
\item{counts}{A matrix of observed counts. Rows represent timepoints, ordered
from most recent to most distant. Columns represent e.g. locations or
data streams.}

\item{baselines}{A matrix of expected counts with the same dimensions as
\code{counts}.}

\item{scalar_priority_fun}{A function taking two arguments \code{c} (count)
and \code{b} (baseline) and returning a scalar.}
}
\value{
A matrix with the same dimensions as \code{counts}. The \eqn{i}th
   element in each column contains the exponential priority function value
   for the window of time (duration) stretching from 1 to \eqn{i}, for that
   column.
}
\description{
Given a matrices with observed and expected values (baselines) for each
timepoint (row) and location/data stream (column), sum counts and baselines
cumulatively backwards in time, and compute the exponential priority function
value for each column and subset of time.
}
\keyword{internal}
