% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between_smd.R, R/print.sc_bcsmd.R
\name{between_smd}
\alias{between_smd}
\alias{print.sc_bcsmd}
\title{Between-Case Standardized Mean Difference}
\usage{
between_smd(data, ...)

\method{print}{sc_bcsmd}(x, digits = 2, ...)
}
\arguments{
\item{data}{Either an scdf or an object returned from the \code{\link[=hplm]{hplm()}} function.}

\item{...}{When data is an scdf, further design parameters passed to the
\code{\link[=hplm]{hplm()}} function.}

\item{x}{An object returned by \code{baseline_smd()}.}

\item{digits}{The minimum number of significant digits to be use.
If set to "auto" (default), values are predefined.}
}
\description{
Calculates a standardized mean difference from a multilevel model as
described in Pustejovsky et al. (2014)
}
\section{Functions}{
\itemize{
\item \code{print(sc_bcsmd)}: Print results

}}
\examples{
des <- design(
  n = 150,
  phase_design = list(A = 10, B = 10, A2 = 10, B2 = 10, c = 10),
  level = list(B = 1, A2 = 0, B2 = 1, c = 1),
  random_start_value = TRUE
)
study <- random_scdf(des)
between_smd(study)

model <- hplm(study, slope = FALSE, contrast_level = "preceding")
between_smd(model)

}
\references{
Pustejovsky, J. E., Hedges, L. V., & Shadish, W. R. (2014). Design-Comparable Effect Sizes in Multiple Baseline Designs: A General Modeling Framework. Journal of Educational and Behavioral Statistics, 39(5), 368–393. https://doi.org/10.3102/1076998614547577
}
