% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mplm.R
\name{mplm}
\alias{mplm}
\title{Multivariate Piecewise linear model / piecewise regression}
\usage{
mplm(
  data,
  dvar,
  mvar,
  pvar,
  model = "W",
  contrast = "first",
  contrast_level = NA,
  contrast_slope = NA,
  trend = TRUE,
  level = TRUE,
  slope = TRUE,
  formula = NULL,
  update = NULL,
  na.action = na.omit,
  ...
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{model}{Model used for calculating the dummy parameters (see Huitema &
McKean, 2000). Default is \code{model = "W"}. Possible values are:
\code{"B&L-B"}, \code{"H-M"}, \code{"W"}, and deprecated \code{"JW"}.}

\item{contrast}{Sets contrast_level and contrast_slope. Either "first", "preceding" or a contrast matrix.}

\item{contrast_level}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{contrast_slope}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{trend}{A logical indicating if a trend parameters is included in the
model.}

\item{level}{A logical indicating if a level parameters is included in the
model.}

\item{slope}{A logical indicating if a slope parameters is included in the
model.}

\item{formula}{Defaults to the standard piecewise regression model. The
parameter phase followed by the phase name (e.g., phaseB) indicates the level effect of the corresponding phase. The parameter 'inter' followed by the phase name (e.g., interB) adresses the slope effect based on the method
provide in the model argument (e.g., "B&L-B"). The formula can be changed
for example to include further variables into the regression model.}

\item{update}{An easier way to change the regression formula (e.g., . ~ . + newvariable).}

\item{na.action}{Defines how to deal with missing values}

\item{...}{Further arguments passed to the lm function.}
}
\value{
\item{model}{Character string from function call (see
\code{Arguments} above).}
\item{full.model}{Full regression model list}
}
\description{
The \code{mplm} function computes a multivariate piecewise regression model.
}
\examples{
res <- mplm(Leidig2018$`1a1`, dvar = c("academic_engagement", "disruptive_behavior"))
print(res)
## also report standardized coefficients:
print(res, std = TRUE)
}
\seealso{
Other regression functions: 
\code{\link{corrected_tau}()},
\code{\link{hplm}()},
\code{\link{plm}()}
}
\author{
Juergen Wilbert
}
\concept{regression functions}
