% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnd.R
\name{pnd}
\alias{pnd}
\title{Percentage of non-overlapping data}
\usage{
pnd(data, dvar, pvar, decreasing = FALSE, phases = c("A", "B"))
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about this format.}

\item{dvar}{Character string with the name of the dependent variable. Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to the attributes in the scdf file.}

\item{decreasing}{If you expect data to be lower in the B phase, set
\code{decreasing = TRUE}. Default is \code{decreasing = FALSE}.}

\item{phases}{A vector of two characters or numbers indicating the two
phases that should be compared. E.g., \code{phases = c("A","C")} or
\code{phases = c(2,4)} for comparing the second to the fourth phase. Phases
could be combined by providing a list with two elements. E.g., \code{phases
= list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2
and 4 (as B). Default is \code{phases = c("A","B")}.}
}
\value{
\item{PND}{Percentage of non-overlapping data.}
}
\description{
This function returns the percentage of non-overlapping data.  Due to its
error-proneness the PND should not be used, but \code{\link{nap}} or
\code{\link{pand}} instead (see Parker & Vannest, 2009).
}
\examples{

## Calculate the PND for multiple single-case data
pnd(GruenkeWilbert2014)

}
\seealso{
Other overlap functions: \code{\link{corrected_tauSC}},
  \code{\link{nap}}, \code{\link{overlapSC}},
  \code{\link{pand}}, \code{\link{pem}}, \code{\link{pet}},
  \code{\link{tauUSC}}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
