\name{randSC}
\alias{randSC}
\alias{rand.test}
\title{Randomization Tests for single-case data}
\description{
The \code{randSC} function computes a randomization test for single or multiple baseline single-case data.  The function is based on an algorithm from the \code{SCRT} package (Bulte & Onghena, 2009, 2012), but rewritten and extended for the use in AB designs.
}

\usage{
randSC(data, statistic = "Mean B-A", number = 500, complete = FALSE, limit = 5, 
       startpoints = NA, exclude.equal = FALSE, graph = FALSE, output = "c")
}

\arguments{
  \item{data}{A single-case data frame or a list of single-case data frames. See \code{\link{makeSCDF}} to learn about this format.}
  \item{statistic}{Defines the statistic on which the comparison of phases A and B is based on. Default setting is \code{statistic = "Mean B-A"}). The following comparisons are possible:
    \itemize{
      \item{\code{"Mean A-B"}: Uses the difference between the mean of phase A and the mean of phase B. This is appropriate if a decrease of scores was expected for phase B.}
      \item{\code{"Mean B-A"}:	Uses the difference between the mean of phase B and the mean of phase A. This is appropriate if an increase of scores was expected for phase B.}
      \item{\code{"Mean |A-B|"}: Uses the absolute value of the difference between the means of phases A and B.}
      \item{\code{"Median A-B"}: The same as \code{"Mean A-B"}, but based on the median.}
      \item{\code{"Median B-A"}: The same as \code{"Mean B-A"}, but based on the median.}
    }
}
  \item{number}{Sample size of the randomization distribution. The exactness of the p-value can not exceed \eqn{1/number} (i.e., \code{number = 100} results in p-values with an exactness of one percent). Default is \code{number = 500}. For faster processing use \code{number = 100}. For more precise p-values set \code{number = 1000}.}
  \item{complete}{If TRUE, the distribution is based on a complete permutation of all possible starting combinations. This setting overwrites the number Argument. The default setting is FALSE.}
  \item{limit}{Minimal number of data points per phase in the sample. Default is \code{limit = 5}.}
  \item{startpoints}{Alternative to the \code{limit}-parameter \code{startpoints} exactly defines the possible start points of phase B (e.g., \code{startpoints = 4:9} restricts the phase B start points to measurements 4 to 9. \code{startpoints} overruns the \code{limit}-parameter.}
  \item{exclude.equal}{If set to \code{exclude.equal = FALSE}, which is the default, random distribution values equal to the observed distribution are counted as null-hypothesis conform. That is, they decrease the probability of rejecting the null-hypothesis (increase the p-value). \code{exclude.equal} should be set to \code{TRUE} if you analyse one single-case design (not a multiple baseline data set) to reach a sufficient power. But be aware, that it increases the chance of an alpha-error.}
  \item{graph}{If \code{graph = TRUE}, a histogram of the resulting distribution is plotted. It's \code{FALSE} by default.}
  \item{output}{If set to the default \code{output = "C"}, detailed information is provided. Set \code{output = "p"}, to only return the resulting p value.}
}

\value{
  \item{statistic}{Character string from function call (see \code{Arguments} above).}
  \item{N}{Number of single-cases.}
  \item{n1}{Number of data points in phase A.}
  \item{n2}{Number of data points in phase B.}
  \item{limit}{Numeric from function call (see \code{Arguments} above).}
  \item{startpoints}{A vector defining the start points passed from the function call (see \code{Arguments} above).}
  \item{p.value}{P-value of the randomization test for the given data.}
  \item{number}{Sample size of randomization distribution from function call (see \code{Arguments} above).}
  \item{complete}{Logical argument from function call (see \code{Arguments} above).}
  \item{observed.statistic}{Test statistic observed for the given single-case data. (see \code{statistic} in the \code{Arguments} above.)}
  \item{Z}{Z-value of observed test statistic.}
  \item{p.z.single}{Probability of z-value.}
  \item{distribution}{Test statistic distribution from randomized data sets.}
  \item{possible.combinations}{Number of possible combinations under the given restrictions.}
  \item{auto.corrected.number}{\code{TRUE} indicates that a corrected number of combinations was used. This happens, if the number of possible combinations (under the given restrictions) undercuts the requested \code{number} of combinations.}
}

\references{
Bulte, I., & Onghena, P. (2009). Randomization tests for multiple-baseline designs: An extension of the SCRT-R package. \emph{Behavior Research Methods, 41}, 477-485.

Bulte, I., & Onghena, P. (2012). \emph{SCRT: Single-Case Randomization Tests}. Available from: \url{https://CRAN.R-project.org/package=SCRT}
}

\author{Juergen Wilbert}

\examples{
## Compute a randomization test on the first case of the byHeart2011 data and include a graph
randSC(byHeart2011[1], statistic = "Median B-A", graph = TRUE)

## Compute a randomization test on the Grosche2011 data using complete permutation
randSC(Grosche2011, statistic = "Median B-A", complete = TRUE, limit = 4)
}

\concept{Randomization}
\concept{Permutation}