\name{smooth.construct.temicv.smooth.spec}
%\Rdversion{1.0}
\alias{smooth.construct.temicv.smooth.spec}

\title{Tensor product smoothing constructor for bivariate function subject to mixed constraints: monotone increasing constraint wrt the first covariate and concavity wrt the second one
}
\description{This is a special method function
  for creating tensor product bivariate smooths subject to mixed constraints, monotone increasing constraint wrt the first covariate and concavity wrt the second one, which is built by 
  the \code{mgcv} constructor function for smooth terms, \code{smooth.construct}. 
  It is constructed from a pair of single penalty marginal smooths which are represented using the B-spline basis functions.  
  This tensor product is specified by model terms such as \code{s(x1,x2,k=c(q1,q2),bs="temicv",m=c(2,2))}, 
  where \code{q1} and \code{q2} denote the basis dimensions for the marginal smooths.
}
\usage{
\method{smooth.construct}{temicv.smooth.spec}(object, data, knots)
}
\arguments{
  \item{object}{A smooth specification object, generated by an \code{s} term in a GAM formula.} 

  \item{data}{A data frame or list containing the values of the elements of \code{object$term},
     with names given by \code{object$term}.}
 
  \item{knots}{An optional list containing the knots corresponding to \code{object$term}. 
          If it is \code{NULL} then the knot locations are generated automatically.}

}
%\details{
%%  ~~ If necessary, more details than the description above ~~
%}
\value{
An object of class \code{"temicv.smooth"}. In addition to the usual 
elements of a smooth class documented under \code{smooth.construct} of the \code{mgcv} library, 
this object contains:
\item{p.ident}{A vector of 0's and 1's for model parameter identification: 
     1's indicate parameters which will be exponentiated, 0's - otherwise.}
\item{Zc}{A matrix of identifiability constraints.}

}
\references{
Pya, N. and Wood, S.N. (2015) Shape constrained additive models. Statistics and Computing, 25(3), 543-559


}
\author{ 
   Natalya Pya <nat.pya@gmail.com>

}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{smooth.construct.tedmd.smooth.spec}}
\code{\link{smooth.construct.temicx.smooth.spec}}
}
\examples{
 \dontrun{
## tensor product `temicv' example 
  ## simulating data...

   set.seed(2)
   n <- 30
   x1 <- sort(runif(n)*4-1)
   x2 <- sort(2*runif(n)-1)
   f1 <- matrix(0,n,n)
   for (i in 1:n) for (j in 1:n) 
       { f1[i,j] <- exp(4*x1[i])/(1+exp(4*x1[i])) - 4*x2[j]^2}    
   f <- as.vector(t(f1))
   y <- f+rnorm(length(f))*0.1
   x11 <-  matrix(0,n,n)
   x11[,1:n] <- x1
   x11 <- as.vector(t(x11))
   x22 <- rep(x2,n)
   dat <- list(x1=x11,x2=x22,y=y)
## fit model ...
   b <- scam(y~s(x1,x2,k=c(10,10),bs="temicv",m=2), data=dat)
## plot results ...
   par(mfrow=c(2,2),mar=c(4,4,2,2))
   plot(b,se=TRUE)
   plot(b,pers=TRUE,theta = 30, phi = 40)
   plot(y,b$fitted.values,xlab="Simulated data",ylab="Fitted data")
   x11()
   vis.scam(b, theta=30)
 }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{models} \keyword{regression}%-- one or more ..


