% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scR.R
\name{scb}
\alias{scb}
\title{Calculate sample complexity bounds for a classifier given target accuracy}
\usage{
scb(vcd = NULL, epsilon = NULL, delta = NULL, eta = NULL, theor = TRUE, ...)
}
\arguments{
\item{vcd}{The Vapnik-Chervonenkis dimension (VCD) of the chosen classifier. If \code{theor} is \code{FALSE}, this can be left unspecified and \code{\link[=simvcd]{simvcd()}} will be called to estimate the VCD}

\item{epsilon}{A real number between 0 and 1 giving the targeted maximum out-of-sample (OOS) error rate}

\item{delta}{A real number between 0 and 1 giving the targeted maximum probability of observing an OOS error rate higher than \code{epsilon}}

\item{eta}{A real number between 0 and 1 giving the probability of misclassification error in the training data.}

\item{theor}{A Boolean indicating whether the theoretical VCD is to be used. If \code{FALSE}, it will instead be estimated using \code{\link[=simvcd]{simvcd()}}}

\item{...}{Arguments to be passed to \code{\link[=simvcd]{simvcd()}}}
}
\value{
A real number giving the sample complexity bound for the specified parameters.
}
\description{
Calculate sample complexity bounds for a classifier given target accuracy
}
\examples{
mylogit <- function(formula, data){
m <- structure(
  glm(formula=formula,data=data,family=binomial(link="logit")),
  class=c("svrclass","glm")  #IMPORTANT - must use the class svrclass to work correctly
)
return(m)
}
mypred <- function(m,newdata){
out <- predict.glm(m,newdata,type="response")
out <- factor(ifelse(out>0.5,1,0),levels=c("0","1"))
#Important - must specify levels to account for possibility of all
#observations being classified into the same class in smaller samples
return(out)
}
library(parallel)
scb(epsilon=0.05,delta=0.05,eta=0.05,theor=FALSE,
model=mylogit,dim=7,m=10,k=10,maxn=50,predictfn = mypred,
    coreoffset = (detectCores() -2))
vcd <- 7
scb(vcd,epsilon=0.05,delta=0.05,eta=0.05)
}
\seealso{
\code{\link[=simvcd]{simvcd()}}, to calculate VCD for a chosen model
}
