% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form_tensor.R
\name{normalize_pseudobulk}
\alias{normalize_pseudobulk}
\title{Normalize the pseudobulked counts matrices. Generally, this should be done through calling the
form_tensor() wrapper function.}
\usage{
normalize_pseudobulk(container, method = "trim", scale_factor = 10000)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{method}{character The normalization method to use on the pseudobulked
count data. Set to 'regular' to do standard normalization of dividing by
library size. Set to 'trim' to use edgeR trim-mean normalization, whereby counts
are divided by library size times a normalization factor. (default='trim')}

\item{scale_factor}{numeric The number that gets multiplied by fractional counts
during normalization of the pseudobulked data (default=10000)}
}
\value{
The project container with normalized pseudobulk matrices in 
container$scMinimal_ctype$<ctype>$pseudobulk slots.
}
\description{
Normalize the pseudobulked counts matrices. Generally, this should be done through calling the
form_tensor() wrapper function.
}
