% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tucker.R
\name{get_all_lds_factor_plots}
\alias{get_all_lds_factor_plots}
\title{Generate loadings heatmaps for all factors}
\usage{
get_all_lds_factor_plots(
  container,
  use_sig_only = FALSE,
  nonsig_to_zero = FALSE,
  annot = "none",
  pathways_list = NULL,
  sim_de_donor_group = NULL,
  sig_thresh = 0.05,
  display_genes = FALSE,
  gene_callouts = FALSE,
  callout_n_gene_per_ctype = 5,
  callout_ctypes = NULL,
  show_var_explained = TRUE,
  reset_other_factor_plots = TRUE
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{use_sig_only}{logical If TRUE, includes only significant genes
from jackstraw in the heatmap. If FALSE, includes all the variable genes.
(default = FALSE)}

\item{nonsig_to_zero}{logical If TRUE, makes the loadings of all nonsignificant genes 0
(default=FALSE)}

\item{annot}{character If set to "pathways" then creates an adjacent heatmap
showing which genes are in which pathways. If set to "sig_genes" then creates
an adjacent heatmap showing which genes were significant from jackstraw. If
set to "none" no adjacent heatmap is plotted. (default="none")}

\item{pathways_list}{list A list of sets of pathways for each factor. List index
should be the number corresponding to the factor. (default=NULL)}

\item{sim_de_donor_group}{numeric To plot the ground truth significant genes from a
simulation next to the heatmap, put the number of the donor group that corresponds to
the factor being plotted. Here it should be a vector corresponding to the factors.
(default=NULL)}

\item{sig_thresh}{numeric Pvalue significance threshold to use. If use_sig_only is
TRUE the threshold is used as a cutoff for genes to include. If annot is "sig_genes"
this value is used in the gene significance colormap as a minimum threshold. (default=0.05)}

\item{display_genes}{logical If TRUE, displays the names of gene names (default=FALSE)}

\item{gene_callouts}{logical If TRUE, then adds gene callout annotations to the heatmap
(default=FALSE)}

\item{callout_n_gene_per_ctype}{numeric To use if gene_callouts is TRUE. Sets the number
of largest magnitude significant genes from each cell type to include in gene callouts.
(default=5)}

\item{callout_ctypes}{list To use if gene_callouts is TRUE. Specifies which cell types
to get gene callouts for. Each entry of the list should be a character vector of ctypes for
the respective factor. If NULL, then gets gene callouts for largest magnitude significant
genes for all cell types. (default=NULL)}

\item{show_var_explained}{logical If TRUE then shows an anottation with the explained variance
for each cell type (default=TRUE)}

\item{reset_other_factor_plots}{logical If TRUE then removes any existing loadings plots (default=TRUE)}
}
\value{
The project container with the list of all loadings heatmap plots placed in 
container$plots$all_lds_plots.
}
\description{
Generate loadings heatmaps for all factors
}
\examples{
test_container <- get_all_lds_factor_plots(test_container)
}
