% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{gating_model}
\alias{gating_model}
\title{Model creation and editing}
\usage{
gating_model(
  model = NULL,
  level = 1,
  name,
  signature,
  positive = TRUE,
  negative = FALSE,
  remove = FALSE
)
}
\arguments{
\item{model}{scGate model to be modified. When is NULL (default) a new model will be initialized.}

\item{level}{integer. It refers to the hierarchical level of the model tree in which the signature will be added (level=1 by default)}

\item{name}{Arbitrary signature name (i.e. Immune, Tcell, NK etc).}

\item{signature}{character vector indicating gene symbols to be included in the signature (e.g. CD3D). If a minus sign is placed to the end of a gene name (e.g. "CD3D-"), this gene will be used as negative in UCell computing. See UCell documentation for details}

\item{positive}{Logical indicating if the signature must be used as a positive signature in those model level. Default is TRUE.}

\item{negative}{Same as `positive` but negated (negative=TRUE equals to positive=FALSE)}

\item{remove}{Whether to remove the given signature from the model}
}
\value{
A scGate model that can be used by \code{\link{scGate}} to filter target cell types.
}
\description{
Generate an scGate model from scratch or edit an existing one
}
\examples{
# create a simple gating model
my_model <- gating_model(level = 1, name = "immune", signature = c("PTPRC"))
my_model <- gating_model(model = my_model, level = 1, positive = FALSE,
    name = "Epithelial", signature = c("CDH1","FLT1") )
# Remove an existing signature
dropped_model <- gating_model(model = my_model, remove =TRUE, level = 1, name = "Epithelial")
}
