% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{CellBender_Feature_Diff}
\alias{CellBender_Feature_Diff}
\title{CellBender Feature Differences}
\usage{
CellBender_Feature_Diff(
  seurat_object = NULL,
  raw_assay = NULL,
  cell_bender_assay = NULL,
  raw_mat = NULL,
  cell_bender_mat = NULL
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{raw_assay}{Name of the assay containing the raw count data.}

\item{cell_bender_assay}{Name of the assay containing the CellBender count data.}

\item{raw_mat}{Name of raw count matrix in environment if not using Seurat object.}

\item{cell_bender_mat}{Name of CellBender count matrix in environment if not using Seurat object.}
}
\value{
A data.frame containing summed raw counts, CellBender counts, count difference, and
percent difference in counts.
}
\description{
Get quick values for raw counts, CellBender counts, count differences, and percent count differences
per feature.
}
\examples{
\dontrun{
cb_stats <- CellBender_Feature_Diff(seurat_object - obj, raw_assay = "RAW",
cell_bender_assay = "RNA")
}

}
\concept{stats}
