% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Liger_to_Seurat}
\alias{Liger_to_Seurat}
\title{Create a Seurat object containing the data from a liger object}
\usage{
Liger_to_Seurat(
  liger_object,
  nms = names(liger_object@H),
  renormalize = TRUE,
  use.liger.genes = TRUE,
  by.dataset = FALSE,
  keep_meta = TRUE,
  reduction_label = "UMAP",
  seurat_assay = "RNA"
)
}
\arguments{
\item{liger_object}{\code{liger} object.}

\item{nms}{By default, labels cell names with dataset of origin (this is to account for cells in
different datasets which may have same name). Other names can be passed here as vector, must have
same length as the number of datasets. (default names(H)).}

\item{renormalize}{Whether to log-normalize raw data using Seurat defaults (default TRUE).}

\item{use.liger.genes}{Whether to carry over variable genes (default TRUE).}

\item{by.dataset}{Include dataset of origin in cluster identity in Seurat object (default FALSE).}

\item{keep_meta}{logical. Whether to transfer additional metadata (nGene/nUMI/dataset already transferred)
to new Seurat Object.  Default is TRUE.}

\item{reduction_label}{Name of dimensionality reduction technique used.  Enables accurate transfer
or name to Seurat object instead of defaulting to "tSNE".}

\item{seurat_assay}{Name to set for assay in Seurat Object.  Default is "RNA".}
}
\value{
Seurat object with raw.data, scale.data, reduction_label, iNMF, and ident slots set.
}
\description{
Merges raw.data and scale.data of object, and creates Seurat object with these values along with
tsne.coords, iNMF factorization, and cluster assignments. Supports Seurat V2 and V3.
}
\details{
Stores original dataset identity by default in new object metadata if dataset names are passed
in nms. iNMF factorization is stored in dim.reduction object with key "iNMF".
}
\examples{
\dontrun{
seurat_object <- Liger_to_Seurat(liger_object = LIGER_OBJ, reduction_label = "UMAP")
}
}
\references{
Original function is part of LIGER package \url{https://github.com/welch-lab/liger} (Licence: GPL-3).
Function was slightly modified for use in scCustomize with keep.meta parameter.  Also posted as
PR to liger GitHub.
}
\concept{object_util}
