% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seurat_Plotting.R
\name{DotPlot_scCustom}
\alias{DotPlot_scCustom}
\title{Customized DotPlot}
\usage{
DotPlot_scCustom(
  seurat_object,
  features,
  colors_use = viridis_plasma_dark_high,
  remove_axis_titles = TRUE,
  x_lab_rotate = FALSE,
  y_lab_rotate = FALSE,
  facet_label_rotate = FALSE,
  flip_axes = FALSE,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Features to plot.}

\item{colors_use}{specify color palette to used.  Default is viridis_plasma_dark_high.}

\item{remove_axis_titles}{logical. Whether to remove the x and y axis titles.  Default = TRUE.}

\item{x_lab_rotate}{Rotate x-axis labels 45 degrees (Default is FALSE).}

\item{y_lab_rotate}{Rotate x-axis labels 45 degrees (Default is FALSE).}

\item{facet_label_rotate}{Rotate facet labels on grouped \code{DotPlots} by 45 degrees (Default is FALSE).}

\item{flip_axes}{whether or not to flip and X and Y axes (Default is FALSE).}

\item{...}{Extra parameters passed to \code{\link[Seurat]{DotPlot}}.}
}
\value{
A ggplot object
}
\description{
Code for creating customized DotPlot
}
\examples{
\donttest{
library(Seurat)
DotPlot_scCustom(seurat_object = pbmc_small, features = c("CD3E", "CD8", "GZMB", "MS4A1"))
}

}
\concept{seurat_plotting}
