% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scCAN.R
\name{scCAN}
\alias{scCAN}
\title{scCAN}
\usage{
scCAN(
  data,
  sparse = FALSE,
  n.neighbors = 30,
  alpha = 0.5,
  n.iters = 10,
  ncores = 10,
  r.seed = 1,
  subsamp = TRUE,
  k = 2:15,
  samp.size = 5000
)
}
\arguments{
\item{data}{Gene expression matrix, with rows represent samples and columns represent genes.}

\item{sparse}{Boolen variable indicating whether data is a sparse matrix. The input must be a non negative sparse matrix.}

\item{n.neighbors}{Number of neighboring cells that are used to caculate the edge's weight. The number of neighbors are set \code{n.neighbors = 30} by default.}

\item{alpha}{A hyper parameter that control the weight of graph. This values is set to \code{alpha = 0.5} by default.}

\item{n.iters}{A hyper-parameter to set the number of network fusion iterations. It is set to \code{n.iters = 10} by default.}

\item{ncores}{Number of processor cores to use.}

\item{r.seed}{A parameter to set a seed for reproducibility. This values is set to \code{r.seed = 1} by default.}

\item{subsamp}{Enable subsampling process for big data. This values is set to \code{subsamp = T} by default.}

\item{k}{A vector to search for optimal number of cluster.}

\item{samp.size}{A parameter to control number of sub-sampled cells.}
}
\value{
List with the following keys:
\itemize{
\item cluster - A numeric vector containing cluster assignment for each sample.
\item k  - The optimal number of cluster.
\item latent - The latent data generated from autoencoders.
}
}
\description{
This is the main function to perform sc-RNA seq data clustering clustering. scCAN is fully unsupervised scRNA-seq
clustering framework that uses deep neural network and network fusion-based clustering algorithm.
First, scCAN applies a non-negative autoencoder to filter scRNA-seq data.
Second, the filtered data is passed to stacked Bayesian autoencoder to get multiple low-dimensional representations of input data.
Subsequently, scCAN converts these compressed data into networks and unify those networks to a single graph.
Then, scCAN uses a spectral clustering algorithm to obtain final clusters assignment.
}
\examples{
\dontrun{
# Not run if scDHA has not installed yet.
# Load the package and the example data (SCE dataset)
library(scCAN)
#Load example data
data("SCE")

#Get data matrix and label
data <- t(SCE$data); label <- as.character(SCE$cell_type1)

#Generate clustering result, the input matrix has rows as samples and columns as genes
result <- scCAN(data, r.seed = 1)

#Get the clustering result
cluster <- result$cluster

#Calculate adjusted Rand Index
ari <- round(scCAN::adjustedRandIndex(cluster,label), 2)
message(paste0("ARI = ", ari))

}
}
\references{
1. Duc Tran, Hung Nguyen, Bang Tran, Carlo La Vecchia, Hung N. Luu, Tin Nguyen (2021). Fast and precise single-cell data analysis using a hierarchical autoencoder. Nature Communications, 12, 1029. doi: 10.1038/s41467-021-21312-2
}
