% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_coverage.R
\name{word_coverage}
\alias{word_coverage}
\alias{word_coverage.sbo_dictionary}
\alias{word_coverage.character}
\alias{word_coverage.sbo_kgram_freqs}
\alias{word_coverage.sbo_predictions}
\title{Word coverage fraction}
\usage{
word_coverage(object, corpus, ...)

\method{word_coverage}{sbo_dictionary}(object, corpus, ...)

\method{word_coverage}{character}(object, corpus, .preprocess = identity, EOS = "", ...)

\method{word_coverage}{sbo_kgram_freqs}(object, corpus, ...)

\method{word_coverage}{sbo_predictions}(object, corpus, ...)
}
\arguments{
\item{object}{either a character vector, or an object inheriting from one of
the classes \code{sbo_dictionary}, \code{sbo_kgram_freqs},
\code{sbo_predtable} or \code{sbo_predictor}.
The object storing the dictionary for which corpus coverage is to be
computed.}

\item{corpus}{a character vector.}

\item{...}{further arguments passed to or from other methods.}

\item{.preprocess}{preprocessing function for training corpus. See
\code{\link[sbo]{kgram_freqs}} and \code{\link[sbo]{sbo_dictionary}} for
further details.}

\item{EOS}{a length one character vector. String containing End-Of-Sentence
characters, see  \code{\link[sbo]{kgram_freqs}} and
\code{\link[sbo]{sbo_dictionary}} for further details.}
}
\value{
a \code{word_coverage} object.
}
\description{
Compute total and cumulative corpus coverage fraction of a dictionary.
}
\details{
This function computes the corpus coverage fraction of a dictionary,
that is the fraction of words appearing in corpus which are contained in the
original dictionary.

This function is a generic, accepting as \code{object} argument any object
storing a dictionary, along with a preprocessing function and a list
of End-Of-Sentence characters. This includes all \code{sbo} main classes:
\code{sbo_dictionary}, \code{sbo_kgram_freqs}, \code{sbo_predtable} and
\code{sbo_predictor}. When \code{object} is a character vector, the preprocessing
function and the End-Of-Sentence characters must be specified explicitly.

The coverage fraction is computed cumulatively, and the dependence of
coverage with respect to maximal rank can be explored through \code{plot()}
(see examples below)
}
\examples{
\donttest{
c <- word_coverage(twitter_dict, twitter_train)
print(c)
summary(c)
# Plot coverage fraction, including the End-Of-Sentence in word counts.
plot(c, include_EOS = TRUE)
}
}
\seealso{
\code{\link[sbo]{predict.sbo_predictor}}
}
\author{
Valerio Gherardi
}
