% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-BipartiteSBM_fit.R
\name{BipartiteSBM_fit}
\alias{BipartiteSBM_fit}
\title{R6 Class definition of an Bipartite SBM fit}
\description{
R6 Class definition of an Bipartite SBM fit

R6 Class definition of an Bipartite SBM fit
}
\details{
This class is designed to give a representation and adjust an LBM fitted with blockmodels.

The list of parameters \code{estimOptions} essentially tunes the optimization process and the variational EM algorithm, with the following parameters
\itemize{
\item{"nbCores"}{integer for number of cores used. Default is 2}
\item{"verbosity"}{integer for verbosity (0, 1). Default is 1}
\item{"plot"}{boolean, should the ICL by dynamically plotted or not. Default is TRUE}
\item{"exploreFactor"}{control the exploration of the number of groups}
\item{"exploreMin"}{explore at least until exploreMin even if the exploration factor rule is achieved. Default 4. See the package blockmodels for details.}
\item{"exploreMin"}{Stop exploration at exploreMax  even if the exploration factor rule is not achieved. Default Inf. See the package blockmodels for details.}
\item{"fast"}{logical: should approximation be used for Bernoulli model with covariates. Default to \code{TRUE}}
}
}
\section{Super classes}{
\code{\link[sbm:SBM]{sbm::SBM}} -> \code{\link[sbm:BipartiteSBM]{sbm::BipartiteSBM}} -> \code{BipartiteSBM_fit}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{loglik}}{double: approximation of the log-likelihood (variational lower bound) reached}

\item{\code{ICL}}{double: value of the integrated classification log-likelihood}

\item{\code{penalty}}{double, value of the penalty term in ICL}

\item{\code{entropy}}{double, value of the entropy due to the clustering distribution}

\item{\code{storedModels}}{data.frame of all models fitted (and stored) during the optimization}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BipartiteSBM_fit$new()}}
\item \href{#method-optimize}{\code{BipartiteSBM_fit$optimize()}}
\item \href{#method-setModel}{\code{BipartiteSBM_fit$setModel()}}
\item \href{#method-reorder}{\code{BipartiteSBM_fit$reorder()}}
\item \href{#method-show}{\code{BipartiteSBM_fit$show()}}
\item \href{#method-clone}{\code{BipartiteSBM_fit$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="print">}\href{../../sbm/html/SBM.html#method-print}{\code{sbm::SBM$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="SBM" data-id="rNetwork">}\href{../../sbm/html/SBM.html#method-rNetwork}{\code{sbm::SBM$rNetwork()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="BipartiteSBM" data-id="plot">}\href{../../sbm/html/BipartiteSBM.html#method-plot}{\code{sbm::BipartiteSBM$plot()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="BipartiteSBM" data-id="predict">}\href{../../sbm/html/BipartiteSBM.html#method-predict}{\code{sbm::BipartiteSBM$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="BipartiteSBM" data-id="rEdges">}\href{../../sbm/html/BipartiteSBM.html#method-rEdges}{\code{sbm::BipartiteSBM$rEdges()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="sbm" data-topic="BipartiteSBM" data-id="rMemberships">}\href{../../sbm/html/BipartiteSBM.html#method-rMemberships}{\code{sbm::BipartiteSBM$rMemberships()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
constructor for a Bipartite SBM fit
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_fit$new(
  incidenceMatrix,
  model,
  dimLabels = c(row = "rowName", col = "colName"),
  covarList = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{incidenceMatrix}}{rectangular (weighted) matrix}

\item{\code{model}}{character (\code{'bernoulli'}, \code{'poisson'}, \code{'gaussian'})}

\item{\code{dimLabels}}{labels of each dimension (in row, in columns)}

\item{\code{covarList}}{and optional list of covariates, each of whom must have the same dimension as \code{incidenceMatrix}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
function to perform optimization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_fit$optimize(estimOptions = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{estimOptions}}{a list of parameters controlling the inference algorithm and model selection. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setModel"></a>}}
\if{latex}{\out{\hypertarget{method-setModel}{}}}
\subsection{Method \code{setModel()}}{
method to select a specific model among the ones fitted during the optimization.
Fields of the current SBM_fit will be updated accordingly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_fit$setModel(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{integer, the index of the model to be selected (row number in storedModels)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reorder"></a>}}
\if{latex}{\out{\hypertarget{method-reorder}{}}}
\subsection{Method \code{reorder()}}{
permute group labels by order of decreasing probability
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_fit$reorder()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
show method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_fit$show(type = "Fit of a Bipartite Stochastic Block Model")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{character used to specify the type of SBM}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BipartiteSBM_fit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
