% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sar_average.R
\name{sar_multi}
\alias{sar_multi}
\title{Create a Collection of SAR Model Fits}
\usage{
sar_multi(data, obj = c("power",
  "powerR","epm1","epm2","p1","p2","loga","koba",
  "mmf","monod","negexpo","chapman","weibull3","asymp",
  "ratio","gompertz","weibull4","betap","heleg","linear"), normaTest =
  "none", homoTest = "none", homoCor = "spearman", grid_start = "partial", 
  grid_n = NULL, verb = TRUE)
}
\arguments{
\item{data}{A dataset in the form of a dataframe with two columns: the first
with island/site areas, and the second with the species richness of each
island/site.}

\item{obj}{A vector of model names.}

\item{normaTest}{The test used to test the normality of the residuals of each
model. Can be any of "lillie" (Lilliefors Kolmogorov-Smirnov test),
"shapiro" (Shapiro-Wilk test of normality), "kolmo" (Kolmogorov-Smirnov
test), or "none" (no residuals normality test is undertaken; the default).}

\item{homoTest}{The test used to check for homogeneity of the residuals of
each model. Can be any of "cor.fitted" (a correlation of the squared
residuals with the model fitted values), "cor.area" (a correlation of the
squared residuals with the area values), or "none" (no residuals
homogeneity test is undertaken; the default).}

\item{homoCor}{The correlation test to be used when \code{homoTest !=
"none"}. Can be any of "spearman" (the default), "pearson", or "kendall".}

\item{grid_start}{Should a grid search procedure be implemented to test
multiple starting parameter values. Can be one of 'none', 'partial' or
'exhaustive' The default is set to 'partial'.}

\item{grid_n}{If \code{grid_start = exhaustive}, the number of points sampled
in the starting parameter space (see details).}

\item{verb}{verbose (default: \code{verb == TRUE}).}
}
\value{
A list of class 'sars' with n elements, corresponding to the n
  individual SAR model fits.
}
\description{
Creates a fit collection of SAR model fits, which can then be
  plotted using \code{\link{plot.sars}}.
}
\details{
The \code{sar_models()} function can be used to bring up a list of
  the 20 model names. \code{display_sars_models()} generates a table of the
  20 models with model information.
}
\examples{
data(galap)
# construct a fit_collection object of 3 SAR model fits
fit2 <- sar_multi(galap, obj = c("power", "loga", "linear"))
plot(fit2)

# construct a fit_collection object of all 20 SAR model fits
# using no grid_start for speed
fit3 <- sar_multi(galap, grid_start = "none")

}
