% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdm.R
\name{gdm}
\alias{gdm}
\title{Fit the General Dynamic Model of Island Biogeography}
\usage{
gdm(data, model = "linear", mod_sel = FALSE, AST = c(1, 2, 3))
}
\arguments{
\item{data}{A dataframe or matrix with at least three columns, where one
column should include island area values, one island richness values and
one island age values.}

\item{model}{Name of the SAR model to be used to fit the GDM. Can be any
of 'logo', 'linear', 'power', or 'all'.}

\item{mod_sel}{Logical argument specifying whether, for a given SAR model,
a model comparison of the GDM with other nested candidate models should
be undertaken.}

\item{AST}{The column locations in \code{data} for the area, richness and
time values (in that order).}
}
\value{
An object of class 'gdm'. If \code{model} is one of "loga",
  "linear" or "power" the returned object is a \code{\link{nls}} model fit
  object. If \code{model == "all"}, the returned object is a list with
  three elements; each element being a \code{nls} fit object.

  If \code{mod_sel == TRUE} and \code{model != "all"}, a list with four
  elements is returned; each element being a \code{lm} or \code{nls} fit
  object. When \code{model == "all"}, a list with three elements is
  returned; each element being a list of the four model fits for a
  particular SAR model.
}
\description{
Fit the general dynamic model (GDM) of island biogeography
  using a variety of SAR models. Functions are provided to compare the GDM
  fitted using different SAR models, and also, for a given SAR model, to
  compare the GDM with alternative nested candidate models (e.g. S ~ A +
  T).
}
\details{
The GDM models island species richness as a function of island
  area and island age, and takes the general form: S ~ A + T + T^2, where
  S = richness, A =area, and T = island age. The T^2 term is included as
  the GDM predicts a hump-shaped relationship between island richness and
  island age. However, a variety of different SAR models have been used to
  fit the GDM and three options are available here: the logarithmic,
  linear and power SAR model. Model fitting follows the procedure in
  Cardoso et al. (2015). For example, when the linear SAR model is used,
  the GDM can be fitted using the expression: S ~ c + z*Area + k*T +
  j*T^2, where c,z,k,j are free parameters to be estimated.

  For all three SAR models, the GDM is fitted using non-linear regression
  and the \code{\link{nls}} function. For ease of fitting, the logarithmic
  and power SAR models are included in their logarithmic form, e.g. the
  logarithmic model is fitted using: S ~ c + x*log(A), where c and x are
  parameters to be estimated.

  For each model fit, the residual standard error (RSE) and AIC values are
  reported. However, as the model fit object is returned, it is possible
  to calculate or extract various other measures of goodness of fit (see
  \code{\link{nls}}).

  If \code{mod_sel == TRUE}, the GDM (using a particular SAR model) is
  fitted and compared with three other (nested) candidate models: area and
  time (i.e. no time^2 term), just area, and an intercept only model. The
  intercept only model is fitted using \code{lm} rather than \code{nls}.
  If \code{model == "all"}, the GDM is fitted three times (using the
  power, loga and linear SAR models), and the fits compared using
  \code{AIC}.
}
\note{
AIC is calculated using the \code{\link{AIC}} function, which is
  based on the log-likelihood and not the residual sum of squares (the
  latter is used in the main functions of the sars package).

  A plot generic function enabling 3-d plotting of the GDM fit will be
  provided in a future version of the package.
}
\examples{
#create an example dataset and fit the GDM using the logarithmic SAR model
data(galap)
galap$t <- rgamma(16, 5, scale = 2)
g <- gdm(galap, model = "loga", mod_sel = FALSE)

#Compare the GDM (using the logarithmic model) with other nested candidate
#models 
g2 <- gdm(galap, model = "loga", mod_sel = TRUE)

#compare the GDM fitted using the linear, logarithmic and power SAR models
g3 <- gdm(galap, model = "all", mod_sel = FALSE)
}
\references{
Whittaker, R. J., Triantis, K. A., & Ladle, R. J. (2008). A
  general dynamic theory of oceanic island biogeography. Journal of
  Biogeography, 35, 977-994.

  Borregaard, M. K. et al. (2017). Oceanic island biogeography through the
  lens of the general dynamic model: assessment and prospect. Biological
  Reviews, 92, 830-853.

  Cardoso, P., Rigal, F., & Carvalho, J. C. (2015). BAT–Biodiversity
  Assessment Tools, an R package for the measurement and estimation of
  alpha and beta taxon, phylogenetic and functional diversity. Methods in
  Ecology and Evolution, 6, 232-236.
}
