% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.clusterSP.R
\name{plot.clusterSP}
\alias{plot.clusterSP}
\title{Plot clustered snow profiles}
\usage{
\method{plot}{clusterSP}(
  x,
  SPx = NULL,
  centers = c("centroids", "medoids", "n")[1],
  include = c(NA, "rta_dist", "pu_dist")[1],
  hardnessResidualSPx = 1,
  SortMethod = c("hs", "unsorted"),
  ...
)
}
\arguments{
\item{x}{a clusterSP object output by \link{clusterSP}}

\item{SPx}{a \link[sarp.snowprofile:snowprofileSet]{sarp.snowprofile::snowprofileSet} to be clustered}

\item{centers}{plot either \code{centroids}, \code{medoids} or \code{none} profiles underneath each set of clustered profiles}

\item{include}{plot \code{rta} or \code{p_unstable} distributions next to centroids}

\item{hardnessResidualSPx}{Value within (0, 1) to control the minimum horizontal space of each layer that will be
e colored irrespective of the layer's hardness. A value of 1 corresponds to no hardness being shown}

\item{SortMethod}{sort profiles within each cluster by either snow depth \code{hs} (default) or \code{unsorted}}

\item{...}{Additional parameters passed to \link[sarp.snowprofile:plot.snowprofileSet]{sarp.snowprofile::plot.snowprofileSet}}
}
\description{
Plot the snowprofileSet sorted and divided by clusters with vertical lines. If available also plot
the centroid or medoid profiles beneath the snowprofileSets.
}
\seealso{
\link{clusterSP}
}
\author{
fherla shorton
}
