% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_corr_network.R
\name{word_corr_network}
\alias{word_corr_network}
\title{Twitter Word Correlations Plot}
\usage{
word_corr_network(
  WordCorr,
  Correlation = 0.15,
  layout = "fr",
  edge_color = "royalblue",
  node_color = "black",
  node_size = 2,
  set_seed = 1234
)
}
\arguments{
\item{WordCorr}{Data Frame of Word Correlations.}

\item{Correlation}{Minimum level of correlation to be displayed.}

\item{layout}{Desired layout from the `ggraph` package.
Acceptable layouts:  "star", "circle", "gem", "dh", "graphopt", "grid", 
"mds", "randomly", "fr", "kk", "drl", "lgl"}

\item{edge_color}{User desired edge color.}

\item{node_color}{User desired node color.}

\item{node_size}{User desired node size.}

\item{set_seed}{Seed for reproducible results.}
}
\value{
An igraph plot
}
\description{
The word correlation network displays the mutual relationship 
  between words.  The correlation network shows higher correlations with a 
  thicker and darker edge color.
}
\examples{
\dontrun{
library(saotd)
data <- raw_tweets
tidy_data <- Tidy(DataFrame = data)
TD_Word_Corr <- word_corr(DataFrameTidy = tidy_data,
                          number = 500,
                          sort = TRUE)
TD_Word_Corr_Network <- word_corr_network(WordCorr = TD_Word_Corr,
                                       Correlation = 0.15,
                                       layout = "fr",
                                       edge_color = "royalblue",
                                       node_color = "black",
                                       node_size = 2,
                                       set_seed = 1234)

TD_Word_Corr_Network
}
}
