% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigram_network.R
\name{bigram_network}
\alias{bigram_network}
\title{Twitter Bi-Gram Network}
\usage{
bigram_network(
  BiGramDataFrame,
  number,
  layout = "fr",
  edge_color = "royalblue",
  node_color = "black",
  node_size = 3,
  set_seed = 1234
)
}
\arguments{
\item{BiGramDataFrame}{Data Frame of Bi-Grams.}

\item{number}{The minimum desired number of Bi-Gram occurrences to be 
displayed (number = 300, would display all Bi-Grams that have at least 
300 instances).}

\item{layout}{Desired layout from the `ggraph` package.
Acceptable layouts:  "star", "circle", "gem", "dh", "graphopt", "grid", 
"mds", "randomly", "fr", "kk", "drl", "lgl"}

\item{edge_color}{User desired edge color.}

\item{node_color}{User desired node color.}

\item{node_size}{User desired node size.}

\item{set_seed}{Seed for reproducible results.}
}
\value{
A ggraph plot.
}
\description{
Displays the Bi-Gram Network.  Bi-Gram networks builds on 
  computed Bi-Grams.  Bi-Gram networks serve as a visualization tool that 
  displays the relationships between the words simultaneously as opposed to 
  a tabular display of Bi-Gram words.
}
\examples{
\dontrun{
library(saotd)
data <- raw_tweets
TD_Bigram <- bigram(DataFrame = data)
TD_Bigram_Network <- bigram_network(BiGramDataFrame = TD_Bigram,
                                    number = 300,
                                    layout = "fr",
                                    edge_color = "royalblue",
                                    node_color = "black",
                                    node_size = 3,
                                    set_seed = 1234)

TD_Bigram_Network
}
}
